/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class HvacFan
extends HvacComponent
implements IHvacObject,
ISignalSink {
    private static final long serialVersionUID = 5609437954326712322L;
    public static final String OPT_FAN_MODEL = "opt_fan_model";
    public static final Integer FAN_MODEL_VOLFLOW = 0;
    public static final Integer FAN_MODEL_PRESDROP = 1;
    public static final Integer FAN_MODEL_QUADRATIC = 2;
    public static final VariantProfile PRESSUREFLOW_PROFILE = new VariantProfile(new DefRampProfile(Intl.intl("Custom"), 39, DefRampProfile.Input.FLOW));
    private TimeFunction d_tauFunc;
    private Variant d_pressureFlowRamp;
    @Deprecated
    private IInPin d_inPin;

    public HvacFan(String id) {
        super(id);
        HvacFan.setDefaults(this);
        this.d_tauFunc = TimeFunction.newDefault();
        this.d_pressureFlowRamp = PRESSUREFLOW_PROFILE.getDefault();
        this.d_inPin = new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_inPin == null) {
            this.d_inPin = new OneLogicInPin(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof HvacFan && super.equals(obj) && theUtil.equal(((HvacFan)obj).d_tauFunc, this.d_tauFunc) && this.d_inPin.equals(((HvacFan)obj).d_inPin);
    }

    @Override
    public Object clone() {
        HvacFan clone = (HvacFan)super.clone();
        clone.d_pressureFlowRamp = this.d_pressureFlowRamp.clone();
        clone.d_tauFunc = (TimeFunction)this.d_tauFunc.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        return clone;
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        this.addDep(deps, "RAMP_ID");
    }

    public static void setDefaults(HvacFan obj) {
        obj.setProp("TYPE_ID", "FAN");
        obj.setProp("TAU_FAN", null);
        obj.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE)));
        obj.setProp(OPT_FAN_MODEL, FAN_MODEL_QUADRATIC);
        obj.setProp("MAX_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide((Unit)SI.SECOND)));
        obj.setProp("MAX_PRESSURE", new UnitDouble(0.0, SI.PASCAL));
        obj.setProp("RAMP_ID", null);
        obj.setProp("VOLUME_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide((Unit)SI.SECOND)));
    }

    public Variant getPressureFlow() {
        return this.d_pressureFlowRamp;
    }

    public void setPressureFlow(Variant flow) {
        if (theUtil.equal(this.d_pressureFlowRamp, flow)) {
            return;
        }
        this.d_pressureFlowRamp = flow;
        this.changedEvt(new Object[0]);
    }

    public TimeFunction getTauFunc() {
        return this.d_tauFunc;
    }

    public void setTauFunc(TimeFunction func) {
        if (theUtil.equal(this.d_tauFunc, func)) {
            return;
        }
        this.d_tauFunc = func;
        this.changedEvt(new Object[0]);
    }
}

