/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class SprayModelMgr
extends Composite<SprayModel> {
    static final long serialVersionUID = 1L;

    public SprayModelMgr() {
        this(Intl.intl("Spray Models"));
    }

    public SprayModelMgr(String name) {
        super(name, SprayModel.class);
    }

    public SprayModel getDefaultWaterSpray(ParticleList particles) {
        SprayModel defaultModel = null;
        for (Particle part : particles.flatten()) {
            if (!part.isType(Particle.Type.LIQUID) || !ExSpecList.equalsPredefinedSpecies(part.getSpecies())) continue;
            defaultModel = new SprayModel(Intl.intl("Water Spray"), part);
        }
        if (defaultModel == null) {
            return null;
        }
        SprayModel modelWithKeyedName = (SprayModel)this.get(Intl.intl("Water Spray"));
        if (modelWithKeyedName == null) {
            return null;
        }
        return modelWithKeyedName.equals(defaultModel) ? modelWithKeyedName : null;
    }

    public void addDefaults(ParticleList particles) {
        List<Pair> defaults = Arrays.asList(new Pair<String, Double>(Intl.intl("Generic Commercial Spray"), 56.1), new Pair<String, Double>(Intl.intl("Generic Industrial Spray"), 80.13), new Pair<String, Double>(Intl.intl("Generic Residential Spray"), 49.05), new Pair<String, Double>(Intl.intl("Generic Storage Spray"), 164.59));
        Particle water = (Particle)particles.get(ParticleList.WATER);
        TimeFunction.TanH func = new TimeFunction.TanH(new UnitDouble(0.0, (Unit)SI.SECOND));
        defaults.forEach(p -> this.addDefault(new SprayModel((String)p.v1, water, new SprayModel.ExplicitFlowRate(new TimeBasedValue<UnitDouble>(SIUS.newud((Double)p.v2, 30), func)))));
    }
}

