/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class GaugeHeatFluxMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_gaugeTemperature;
    private double d_gaugeEmissivity;

    public GaugeHeatFluxMeasurer(String name, UnitDouble gaugeTemperature, AttachedPointLoc loc) {
        this(name, gaugeTemperature, 0.9, loc);
    }

    public GaugeHeatFluxMeasurer(String name, UnitDouble gaugeTemperature, double gaugeEmissivity, AttachedPointLoc loc) {
        super(name, Quantity.GAUGE_HEAT_FLUX.create(), loc);
        this.d_gaugeTemperature = gaugeTemperature;
        this.d_gaugeEmissivity = gaugeEmissivity;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GaugeHeatFluxMeasurer && super.equals(obj) && theUtil.equal(this.d_gaugeTemperature, ((GaugeHeatFluxMeasurer)obj).d_gaugeTemperature) && theUtil.equal(this.d_gaugeEmissivity, ((GaugeHeatFluxMeasurer)obj).d_gaugeEmissivity);
    }

    public void setGaugeTemperature(UnitDouble temp) {
        this.d_gaugeTemperature = temp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getGaugeTemperature() {
        return this.d_gaugeTemperature;
    }

    public void setGaugeEmissivity(double emiss) {
        this.d_gaugeEmissivity = emiss;
        this.changedEvt(new Object[0]);
    }

    public double getGaugeEmissivity() {
        return this.d_gaugeEmissivity;
    }
}

