/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.devices.IAARectDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.HashPool;

public class FlowMeasurer
extends AMeasuringDevc
implements IAARectDevice {
    static final long serialVersionUID = 1L;
    public static final int FLOWDIR_POS = 0;
    public static final int FLOWDIR_NEG = 1;
    public static final int FLOWDIR_BOTH = 2;
    private AARectangle d_rect;
    private int d_flowDir;
    private static final IPrimProps s_primProps = new IPrimProps.Face(new Color(1.0f, 1.0f, 0.0f, 0.5f), null, 0);

    public FlowMeasurer(String name, IQuantity measurment, AARectangle rect, int flowDir) {
        super(name, measurment);
        this.d_rect = rect;
        this.d_flowDir = flowDir;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FlowMeasurer)) {
            return false;
        }
        FlowMeasurer flow = (FlowMeasurer)obj;
        return super.equals(obj) && this.d_flowDir == flow.d_flowDir && this.d_rect.equals(flow.d_rect);
    }

    private static int toFlowDir(Vector3d vec) {
        if (vec.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-9) || vec.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-9) || vec.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-9)) {
            return 1;
        }
        return 0;
    }

    private static Vector3d toFlowVec(AARectangle rect, int dir) {
        switch (rect.d_plane) {
            case 0: {
                switch (dir) {
                    case 0: {
                        return GeomConstants.VEC3D_XPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_XNEG;
                    }
                }
                break;
            }
            case 1: {
                switch (dir) {
                    case 0: {
                        return GeomConstants.VEC3D_YPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_YNEG;
                    }
                }
                break;
            }
            case 2: {
                switch (dir) {
                    case 0: {
                        return GeomConstants.VEC3D_ZPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_ZNEG;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public AARectangle getRect() {
        return this.d_rect;
    }

    public void setRect(AARectangle rect) {
        this.d_rect = rect;
        this.changedEvt(new Object[0]);
    }

    public int getFlowDir() {
        return this.d_flowDir;
    }

    public void setFlowDir(int dir) {
        this.d_flowDir = dir;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType[] getQuantityTypes() {
        return new QuantityType[]{QuantityType.GAS, QuantityType.SOLID};
    }

    public static long getOutputType() {
        return 2L;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(FlowMeasurer.getOutputType(), FlowMeasurer.getQuantityTypes());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getFlowGeom());
    }

    public IGeom getFlowGeom() {
        return new FlowMsrGeom(this.d_rect, this.d_flowDir);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof FlowMsrGeom) {
            FlowMsrGeom f = (FlowMsrGeom)geom;
            this.pauseUpdates();
            this.setRect(new AARectangle(f.d_plane, f.d_planeVal, f.d_minx, f.d_miny, f.d_maxx, f.d_maxy, f.flipped));
            this.setFlowDir(f.flowDir);
            this.resumeUpdates();
        } else if (geom instanceof AARectangle) {
            this.setRect((AARectangle)geom);
        }
    }

    private static class FlowMsrGeom
    extends AARectangle {
        private static final long serialVersionUID = 2650183771693314825L;
        public final int flowDir;

        public FlowMsrGeom(AARectangle baseRect, int flowDir) {
            super(baseRect.d_plane, baseRect.d_planeVal, baseRect.d_minx, baseRect.d_miny, baseRect.d_maxx, baseRect.d_maxy, baseRect.flipped);
            this.flowDir = flowDir;
        }

        public FlowMsrGeom optimize(HashPool<Point3d> pool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IPolygon transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            AABox bb = new AABox();
            this.getBoundingBox(bb);
            Point3d p1 = Util3D.xform(xform, bb.getMin());
            Point3d p2 = Util3D.xform(xform, bb.getMax());
            AARectangle newRect = AARectangle.construct(p1, p2, false);
            int newFlowDir = this.flowDir;
            if (this.flowDir != 2) {
                Vector3d flowVec = FlowMeasurer.toFlowVec(this, this.flowDir);
                flowVec.normalize();
                flowVec = Util3D.xform(xform, flowVec);
                newFlowDir = FlowMeasurer.toFlowDir(flowVec);
            }
            return new FlowMsrGeom(newRect, newFlowDir);
        }
    }
}

