/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.hvac;

import java.util.Collection;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class HvacDevice
extends ADevice
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;

    public HvacDevice(String name, IQuantity msr) {
        super(name);
        this.d_msr = msr;
    }

    public IQuantity getQuantity() {
        return this.d_msr;
    }

    public void setQuantity(IQuantity msr) {
        this.d_msr = msr;
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDevcGeom());
    }

    protected abstract IGeom getDevcGeom();

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    public static Point3d getPointForNode(HvacNode n) {
        if (n != null && n.getProp("XYZ") != null) {
            return ((UnitPoint3D)n.getProp("XYZ")).getPoint3dValue((Unit)SI.METER);
        }
        return null;
    }

    public static boolean isValidQuantity(IQuantity quantity) {
        if (!(quantity instanceof ObjectQuantity)) {
            return false;
        }
        ObjectQuantity oq = (ObjectQuantity)quantity;
        for (Object o : oq.objects) {
            if (!(o instanceof HvacDuct) && !(o instanceof HvacNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        assert (this.d_msr != null);
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.d_msr);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.d_msr);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.d_msr);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)HvacDevice.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    HvacDevice.this.d_msr = obj;
                    HvacDevice.this.changedEvt(new Object[0]);
                }
            };
        }
    }
}

