/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import thunderheadeng.units.UnitDouble;

public class SmokeLinkModelMgr
extends Composite<SmokeLinkModel>
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final String d_defaultModelName = Intl.intl("Cleary Photoelectric P1");

    public SmokeLinkModelMgr() {
        this(Intl.intl("Smoke Links"));
    }

    public SmokeLinkModelMgr(String name) {
        super(name, SmokeLinkModel.class);
    }

    public void addDefaults() {
        SmokeLinkModel def = new SmokeLinkModel("default");
        UnitDouble defObsc = def.getActivationObscuration();
        this.addDefault(new SmokeLinkModel(Intl.intl("Cleary Ionization I1"), defObsc, null, new SmokeLinkModel.Cleary(0.8, -0.9, 2.5, -0.7)));
        this.addDefault(new SmokeLinkModel(Intl.intl("Cleary Ionization I2"), defObsc, null, new SmokeLinkModel.Cleary(1.0, -0.8, 1.8, -1.1)));
        this.addDefault(new SmokeLinkModel(d_defaultModelName, defObsc, null, new SmokeLinkModel.Cleary(1.0, -0.8, 1.8, -1.0)));
        this.addDefault(new SmokeLinkModel(Intl.intl("Cleary Photoelectric P2"), defObsc, null, new SmokeLinkModel.Cleary(0.8, -0.8, 1.8, -0.8)));
        this.addDefault(new SmokeLinkModel(Intl.intl("Heskestad Ionization"), defObsc, null, new SmokeLinkModel.Heskestad(new UnitDouble(1.8, (Unit)SI.METER))));
    }

    public SmokeLinkModel getDefaultModel() {
        SmokeLinkModel defaultModel = (SmokeLinkModel)this.get(d_defaultModelName);
        if (defaultModel != null) {
            return defaultModel;
        }
        return !this.getChildren().isEmpty() ? (SmokeLinkModel)this.getChildren().iterator().next() : null;
    }
}

