/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.Serializable;
import pyrosim.domain.TimeFunction;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class TempRegulation
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_htCoef;
    public final ThermalBCs d_thermalBCs;
    public final boolean d_logarithmic;
    public final boolean d_calculatedTemp;
    private static TempRegulation s_defaultNetHeatFluxTR = null;
    private static TempRegulation s_defaultFixedHeatFluxTR = null;
    private static TempRegulation s_defaultFixedTempTR = null;
    private static TempRegulation s_defaultCalcTempTR = null;
    private static TempRegulation s_defaultAdiabaticTR = null;

    private TempRegulation(ThermalBCs boundaryConds, UnitDouble htCoef, boolean log, boolean calculatedTemp) {
        this.d_thermalBCs = boundaryConds;
        this.d_htCoef = htCoef;
        this.d_logarithmic = log;
        this.d_calculatedTemp = calculatedTemp;
    }

    public static TempRegulation newNetHeatFluxTR(UnitDouble netHeatFlux, TimeFunction netFluxRamp, double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(ThermalBCs.newNetHeatFluxBCs(netHeatFlux, netFluxRamp, emissivity), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation defaultNetHeatFluxTR() {
        if (s_defaultNetHeatFluxTR == null) {
            s_defaultNetHeatFluxTR = TempRegulation.newNetHeatFluxTR(new UnitDouble(0.0, SIUS.getInstance().getUnit(33)), TimeFunction.newDefault(), 0.9, null, false);
        }
        return s_defaultNetHeatFluxTR;
    }

    public static TempRegulation newFixedHeatFluxTR(UnitDouble temperature, TimeFunction tempRamp, UnitDouble heatFlux, TimeFunction heatFluxRamp, double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(ThermalBCs.newTotalHeatFluxBCs(temperature, tempRamp, heatFlux, heatFluxRamp, emissivity), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation defaultFixedHeatFluxTR() {
        if (s_defaultFixedHeatFluxTR == null) {
            s_defaultFixedHeatFluxTR = TempRegulation.newFixedHeatFluxTR(new UnitDouble(0.0, SIUS.getInstance().getUnit(1)), TimeFunction.newDefault(), new UnitDouble(0.0, SIUS.getInstance().getUnit(33)), TimeFunction.newDefault(), 0.9, null, false);
        }
        return s_defaultFixedHeatFluxTR;
    }

    public static TempRegulation newFixedTempTR(UnitDouble temperature, TimeFunction tempRamp, double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(ThermalBCs.newFixedTempBCs(temperature, tempRamp, emissivity), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation defaultFixedTempTR() {
        if (s_defaultFixedTempTR == null) {
            s_defaultFixedTempTR = TempRegulation.newFixedTempTR(new UnitDouble(0.0, SIUS.getInstance().getUnit(1)), TimeFunction.newDefault(), 0.9, null, false);
        }
        return s_defaultFixedTempTR;
    }

    public static TempRegulation newCalcTempTR(double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(ThermalBCs.newCalcTempBCs(emissivity), htCoef, log, true);
    }

    public static TempRegulation defaultCalcTempTR() {
        if (s_defaultCalcTempTR == null) {
            s_defaultCalcTempTR = TempRegulation.newCalcTempTR(0.9, null, false);
        }
        return s_defaultCalcTempTR;
    }

    public static TempRegulation newDefault() {
        return new TempRegulation(ThermalBCs.newDefaultBCs(), TempRegulation.getDefaultHtCoef(), TempRegulation.getDefaultLog(), TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newAdiabaticTR(UnitDouble htCoef, boolean log) {
        return new TempRegulation(ThermalBCs.newAdiabaticBCs(), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation defaultAdiabaticTR() {
        if (s_defaultAdiabaticTR == null) {
            s_defaultAdiabaticTR = TempRegulation.newAdiabaticTR(null, false);
        }
        return s_defaultAdiabaticTR;
    }

    public static double getDefaultEmissivity() {
        return 0.9;
    }

    public static UnitDouble getDefaultHtCoef() {
        return null;
    }

    public static boolean getDefaultLog() {
        return false;
    }

    public static boolean getDefaultAdiabatic() {
        return false;
    }

    public static boolean getDefaultCalculatedTemp() {
        return false;
    }

    public boolean isNetHeatFluxTR() {
        return this.d_thermalBCs.d_netHeatFlux != null;
    }

    public boolean isAdiabaticTR() {
        return this.d_thermalBCs.d_isAdiabatic;
    }

    public boolean isFixedTempTR() {
        return !this.isNetHeatFluxTR() && !this.isAdiabaticTR() && !this.isGrossFluxTR();
    }

    public boolean isCalcTempTR() {
        return this.d_calculatedTemp;
    }

    public boolean isGrossFluxTR() {
        return this.d_thermalBCs.d_convHeatFlux != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TempRegulation)) {
            return false;
        }
        TempRegulation reg = (TempRegulation)obj;
        return theUtil.equal(this.d_htCoef, reg.d_htCoef) && this.d_logarithmic == reg.d_logarithmic && this.d_thermalBCs.equals(reg.d_thermalBCs);
    }

    public static class ThermalBCs
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_temp;
        public final UnitDouble d_convHeatFlux;
        public final UnitDouble d_netHeatFlux;
        public final TimeFunction d_tempRamp;
        public final TimeFunction d_convFluxRamp;
        public final TimeFunction d_netFluxRamp;
        public final double d_emissivity;
        public final boolean d_isAdiabatic;

        private ThermalBCs(UnitDouble temp, TimeFunction tempRamp, UnitDouble convFlux, TimeFunction convRamp, UnitDouble netFlux, TimeFunction netRamp, double emissivity, boolean isAdiabatic) {
            this.d_temp = temp;
            this.d_tempRamp = tempRamp;
            this.d_convHeatFlux = convFlux;
            this.d_convFluxRamp = convRamp;
            this.d_netHeatFlux = netFlux;
            this.d_netFluxRamp = netRamp;
            this.d_emissivity = emissivity;
            this.d_isAdiabatic = isAdiabatic;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_temp);
            hash = 31 * hash + theUtil.hashCode(this.d_tempRamp);
            hash = 31 * hash + theUtil.hashCode(this.d_netHeatFlux);
            hash = 31 * hash + theUtil.hashCode(this.d_netFluxRamp);
            hash = 31 * hash + theUtil.hashCode(this.d_convHeatFlux);
            hash = 31 * hash + theUtil.hashCode(this.d_convFluxRamp);
            hash = 31 * hash + theUtil.hashCode(this.d_emissivity);
            hash = 31 * hash + theUtil.hashCode(this.d_isAdiabatic);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ThermalBCs)) {
                return false;
            }
            ThermalBCs bcs = (ThermalBCs)obj;
            return theUtil.equal(this.d_temp, bcs.d_temp) && theUtil.equal(this.d_tempRamp, bcs.d_tempRamp) && theUtil.equal(this.d_netHeatFlux, bcs.d_netHeatFlux) && theUtil.equal(this.d_netFluxRamp, bcs.d_netFluxRamp) && theUtil.equal(this.d_convHeatFlux, bcs.d_convHeatFlux) && theUtil.equal(this.d_convFluxRamp, bcs.d_convFluxRamp) && theUtil.equal(this.d_emissivity, bcs.d_emissivity) && theUtil.equal(this.d_isAdiabatic, bcs.d_isAdiabatic);
        }

        public static ThermalBCs newFixedTempBCs(UnitDouble temp, TimeFunction tempRamp, double emissivity) {
            return new ThermalBCs(temp, tempRamp, null, null, null, null, emissivity, false);
        }

        public static ThermalBCs newAdiabaticBCs() {
            return new ThermalBCs(null, null, null, null, null, null, 1.0, true);
        }

        public static ThermalBCs newNetHeatFluxBCs(UnitDouble netFlux, TimeFunction netFluxRamp, double emissivity) {
            return new ThermalBCs(null, null, null, null, netFlux, netFluxRamp, emissivity, false);
        }

        public static ThermalBCs newTotalHeatFluxBCs(UnitDouble temp, TimeFunction tempRamp, UnitDouble convFlux, TimeFunction convFluxRamp, double emissivity) {
            return new ThermalBCs(temp, tempRamp, convFlux, convFluxRamp, null, null, emissivity, false);
        }

        public static ThermalBCs newCalcTempBCs(double emissivity) {
            return new ThermalBCs(null, null, null, null, null, null, emissivity, false);
        }

        public static ThermalBCs newDefaultBCs() {
            return new ThermalBCs(null, TimeFunction.newDefault(), null, TimeFunction.newDefault(), null, TimeFunction.newDefault(), TempRegulation.getDefaultEmissivity(), false);
        }
    }
}

