/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.util.Util;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SpecInjList
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int MASS_FLUX = 0;
    public static final int MASS_FRACTION = 1;
    public final int injType;
    private final Map<ExSpec, SpeciesInjection> d_injections;

    public SpecInjList() {
        this(0, new ArrayList<SpeciesInjection>(0));
    }

    public SpecInjList(int injType, List<SpeciesInjection> injections) {
        this.injType = injType;
        this.d_injections = new LinkedIdentityHashMap<ExSpec, SpeciesInjection>(injections.size());
        for (SpeciesInjection inj : injections) {
            this.d_injections.put(inj.species, inj);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(this.d_injections instanceof LinkedIdentityHashMap)) {
            try {
                theUtil.assignFinalField(this, SpecInjList.class, "d_injections", new LinkedIdentityHashMap<ExSpec, SpeciesInjection>(this.d_injections));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.injType);
        hash = 31 * hash + theUtil.hashCode(this.d_injections);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpecInjList)) {
            return false;
        }
        SpecInjList list = (SpecInjList)obj;
        return this.injType == list.injType && Util.identityMapsEqual(this.d_injections, list.d_injections);
    }

    public Collection<SpeciesInjection> getInjections() {
        return this.d_injections.values();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_injections.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, ExSpec.class);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (!this.d_injections.containsKey(old)) {
            return null;
        }
        return new AUndoableTask(){
            private SpeciesInjection d_inj;
            private boolean d_replAdded;

            @Override
            public void undo() {
                if (this.d_replAdded) {
                    SpecInjList.this.d_injections.remove(replacement);
                }
                SpecInjList.this.d_injections.put(this.d_inj.species, this.d_inj);
            }

            @Override
            public void run() {
                this.d_inj = (SpeciesInjection)SpecInjList.this.d_injections.remove(old);
                if (replacement != null && !SpecInjList.this.d_injections.containsKey(replacement)) {
                    SpeciesInjection newInj = new SpeciesInjection((ExSpec)replacement, this.d_inj.val, this.d_inj.func);
                    SpecInjList.this.d_injections.put((ExSpec)replacement, newInj);
                    this.d_replAdded = true;
                } else {
                    this.d_replAdded = false;
                }
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }
}

