/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class AirFlow
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Rate d_rate;
    public final IProfile d_profile;

    public AirFlow() {
        this(new VolumeFlux(), new TopHatProf());
    }

    public AirFlow(Rate rate, IProfile profile) {
        this.d_rate = rate;
        this.d_profile = profile;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.d_rate);
        hash = 31 * hash + theUtil.hashCode(this.d_profile);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AirFlow)) {
            return false;
        }
        AirFlow af = (AirFlow)obj;
        return this.d_rate.equals(af.d_rate) && this.d_profile.equals(af.d_profile);
    }

    public static class TopHatProf
    implements IProfile {
        static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            return obj instanceof TopHatProf;
        }
    }

    public static class ParabolicProf
    implements IProfile {
        static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            return obj instanceof ParabolicProf;
        }
    }

    public static class AtmosphericProf
    implements IProfile {
        static final long serialVersionUID = 1L;
        public final double d_exponent;
        public final UnitDouble d_origin;

        public AtmosphericProf() {
            this(0.3, new UnitDouble(10.0, (Unit)SI.METER));
        }

        public AtmosphericProf(double exponent, UnitDouble origin) {
            this.d_exponent = exponent;
            this.d_origin = origin;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_exponent);
            hash = 31 * hash + theUtil.hashCode(this.d_origin);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AtmosphericProf)) {
                return false;
            }
            AtmosphericProf p = (AtmosphericProf)obj;
            return this.d_exponent == p.d_exponent && this.d_origin.equals(p.d_origin);
        }
    }

    public static interface IProfile
    extends Serializable {
    }

    public static class ExSpecMassFlux
    extends Rate {
        static final long serialVersionUID = 1L;

        public ExSpecMassFlux() {
            this(SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public ExSpecMassFlux(UnitDouble tanVelU, UnitDouble tanVelV, TimeFunction timeFunc, SpecInjList specInj) {
            super(tanVelU, tanVelV, timeFunc, specInj);
            assert (ExSpecMassFlux.specInjValid(specInj));
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + super.hashCode();
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ExSpecMassFlux && super.equals(obj);
        }

        public static boolean specInjValid(SpecInjList inj) {
            return inj == null || inj.injType == 0;
        }
    }

    public static class TotalMassFlux
    extends ValRate {
        static final long serialVersionUID = 1L;

        public TotalMassFlux() {
            super(SIUS.newud(0.0, 45), SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public TotalMassFlux(UnitDouble fluxTotal, UnitDouble tanVelU, UnitDouble tanVelV, TimeFunction func, SpecInjList specInj) {
            super(fluxTotal, tanVelU, tanVelV, func, specInj);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TotalMassFlux && super.equals(obj);
        }
    }

    public static class VolumeFlux
    extends ValRate {
        static final long serialVersionUID = 1L;

        public VolumeFlux() {
            this(SIUS.newud(0.0, 24), SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public VolumeFlux(UnitDouble volFlux, UnitDouble tanVelU, UnitDouble tanVelV, TimeFunction func, SpecInjList specInj) {
            super(volFlux, tanVelU, tanVelV, func, specInj);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof VolumeFlux && super.equals(obj);
        }
    }

    public static class NormalVel
    extends ValRate {
        static final long serialVersionUID = 1L;

        public NormalVel() {
            this(SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public NormalVel(UnitDouble vel, UnitDouble tanVelU, UnitDouble tanVelV, TimeFunction func, SpecInjList specInj) {
            super(vel, tanVelU, tanVelV, func, specInj);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NormalVel && super.equals(obj);
        }
    }

    public static abstract class ValRate
    extends Rate {
        static final long serialVersionUID = 1L;
        public final UnitDouble val;

        public ValRate(UnitDouble val, UnitDouble tanVelU, UnitDouble tanVelV, TimeFunction func, SpecInjList specInj) {
            super(tanVelU, tanVelV, func, specInj);
            assert (ValRate.specInjValid(specInj));
            this.val = val;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ValRate)) {
                return false;
            }
            ValRate r = (ValRate)obj;
            return super.equals(obj) && this.val.equals(r.val);
        }

        public static boolean specInjValid(SpecInjList inj) {
            return inj == null || inj.injType == 1;
        }
    }

    public static class Rate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble tanVelU;
        public final UnitDouble tanVelV;
        public final TimeFunction func;
        public final SpecInjList specInj;

        public Rate(UnitDouble tanVelU, UnitDouble tanVelV, TimeFunction timeFunc, SpecInjList specInj) {
            this.tanVelU = tanVelU;
            this.tanVelV = tanVelV;
            this.func = timeFunc;
            this.specInj = specInj;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.tanVelU);
            hash = 31 * hash + theUtil.hashCode(this.tanVelV);
            hash = 31 * hash + theUtil.hashCode(this.func);
            hash = 31 * hash + theUtil.hashCode(this.specInj);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Rate)) {
                return false;
            }
            Rate es = (Rate)obj;
            return this.tanVelU.equals(es.tanVelU) && this.tanVelV.equals(es.tanVelV) && this.func.equals(es.func) && theUtil.equal(this.specInj, es.specInj);
        }
    }
}

