/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.mat;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.Reaction;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class LiquidReaction
extends Reaction {
    static final long serialVersionUID = 1L;
    public final Rate d_rate;

    public LiquidReaction() {
        this(new Rate(), new ReacByproducts(null, null, null, null, SIUS.newud(0.0, 46)));
    }

    public LiquidReaction(Rate rate, ReacByproducts byproducts) {
        super(byproducts);
        this.d_rate = rate;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.d_rate);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LiquidReaction)) {
            return false;
        }
        LiquidReaction lr = (LiquidReaction)obj;
        return super.equals(obj) && this.d_rate.equals(lr.d_rate);
    }

    public static class Rate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_boilingTemp;

        public Rate() {
            this(new UnitDouble(100.0, SI.CELSIUS));
        }

        public Rate(UnitDouble boilingTemp) {
            this.d_boilingTemp = boilingTemp;
        }

        public int hashCode() {
            int hash = 13;
            hash = 41 * hash + theUtil.hashCode(this.d_boilingTemp);
            return hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof Rate && this.d_boilingTemp.equals(((Rate)obj).d_boilingTemp);
        }
    }
}

