/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.GeomLocator;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.geom.IGeomSource;
import pyrosim.util.LWIdentityHashSet;
import thunderheadeng.geometry.AABox;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theTimer;

public class GeomProximity {
    private boolean d_enabled = true;
    private final PyroMod d_domain;
    private final Map<IGeomSource, LWIdentityHashSet<IGeomSource>> d_proximityMap;
    private Set<IGeomSource> d_dirty;
    private static final Predicate<FDSObject> s_holeTargetFilter = new Predicate<FDSObject>(){

        @Override
        public boolean test(FDSObject o) {
            return o instanceof IObstruction;
        }
    };
    private static final Predicate<FDSObject> s_holeFilter = new Predicate<FDSObject>(){

        @Override
        public boolean test(FDSObject o) {
            return o instanceof IHole;
        }
    };

    public GeomProximity(PyroMod domain) {
        this.d_domain = domain;
        this.d_proximityMap = new IdentityHashMap<IGeomSource, LWIdentityHashSet<IGeomSource>>();
        this.d_dirty = GeomProximity.newDirtySet();
    }

    private static Set<IGeomSource> newDirtySet() {
        return new LinkedIdentityHashSet<IGeomSource>();
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.d_enabled) {
            return;
        }
        this.d_enabled = enabled;
        if (!this.d_enabled) {
            this.d_proximityMap.clear();
            this.d_dirty = GeomProximity.newDirtySet();
        }
    }

    public void add(IGeomSource geom) {
        if (!this.d_enabled) {
            return;
        }
        this.d_dirty.add(geom);
    }

    public void remove(IGeomSource geom) {
        if (!this.d_enabled) {
            return;
        }
        this.disconnect(geom);
        this.d_dirty.remove(geom);
    }

    public void update(IGeomSource geom) {
        if (!this.d_enabled) {
            return;
        }
        this.disconnect(geom);
        this.d_dirty.add(geom);
    }

    private void disconnect(IGeomSource geom) {
        LWIdentityHashSet<IGeomSource> coll1 = this.d_proximityMap.get(geom);
        if (coll1 == null) {
            return;
        }
        for (IGeomSource nearObj : coll1) {
            LWIdentityHashSet<IGeomSource> coll2 = this.d_proximityMap.get(nearObj);
            assert (coll2 != null);
            coll2.remove(geom);
            if (coll2.isEmpty()) {
                this.d_proximityMap.remove(nearObj);
            }
            this.fireUpdate(nearObj);
        }
        this.d_proximityMap.remove(geom);
        this.fireUpdate(geom);
    }

    private void fireUpdate(IGeomSource geom) {
        if (geom instanceof IObstruction) {
            ((IObstruction)geom).changedEvt(PyroMod.EVT_APPEARANCE);
        }
    }

    public void update() {
        if (this.d_dirty.isEmpty()) {
            return;
        }
        this.d_domain.getGeomLocator().updateDirty();
        theTimer timer = new theTimer();
        this.d_domain.pauseUpdates();
        for (IGeomSource geom : this.d_dirty) {
            if (!(geom instanceof FDSObject)) continue;
            FDSObject obj = (FDSObject)geom;
            Collection<? extends IGeomSource> nearObjs = null;
            if (obj instanceof IHole) {
                nearObjs = this.findHoleTargets(obj);
            } else if (obj instanceof IObstruction) {
                nearObjs = this.findNearHoles(obj);
            }
            if (nearObjs == null || nearObjs.isEmpty()) continue;
            LWIdentityHashSet coll = this.getNearObjsForAdd(obj);
            coll.addAll(nearObjs);
            for (IGeomSource iGeomSource : nearObjs) {
                this.getNearObjsForAdd(iGeomSource).add(obj);
                this.fireUpdate(iGeomSource);
            }
            this.fireUpdate(obj);
        }
        this.d_dirty = GeomProximity.newDirtySet();
        if (System.getProperty("dev") != null) {
            System.out.println("updated geom prox " + timer.curr());
        }
        this.d_domain.resumeUpdates();
    }

    private Collection<? extends IGeomSource> findHoleTargets(IGeomSource obj) {
        return this.findNearObjs(obj, s_holeTargetFilter);
    }

    private Collection<? extends IGeomSource> findNearHoles(IGeomSource obj) {
        return this.findNearObjs(obj, s_holeFilter);
    }

    private Collection<FDSObject> findNearObjs(IGeomSource obj, Predicate<FDSObject> filter) {
        AABox bounds = GeomUtil.getBounds(obj);
        GeomLocator.Collector<FDSObject> collector = new GeomLocator.Collector<FDSObject>(FDSObject.class, filter);
        this.d_domain.getGeomLocator().findf(bounds.toAABoxf(), collector, true);
        return collector.coll;
    }

    private LWIdentityHashSet getNearObjsForAdd(IGeomSource obj) {
        LWIdentityHashSet<IGeomSource> coll = this.d_proximityMap.get(obj);
        if (coll == null) {
            coll = new LWIdentityHashSet();
            this.d_proximityMap.put(obj, coll);
        }
        return coll;
    }

    public Collection<? extends IGeomSource> getNearObjs(IGeomSource obj) {
        LWIdentityHashSet<IGeomSource> coll = this.d_proximityMap.get(obj);
        if (coll == null) {
            return Collections.EMPTY_LIST;
        }
        return coll;
    }
}

