/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.view.View;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.TaskManager;

public class PyroTaskManager
extends TaskManager {
    private final PyroMod d_pyMod;
    public static final int OPT_RETAIN_CURR_TOOL = 1;
    public static final int OPT_RESET_CAMERA = 2;
    public static final int OPT_IGNORE_WRITE_PROTECT = 4;
    public static final int OPT_RETAIN_VIEW_CAMERA = 8;
    public static final int OPT_BYPASS_UNDO = 16;
    public static final int OPT_SELECT_SELECTION_TOOL = 32;

    public PyroTaskManager(PyroMod pyMod) {
        this.d_pyMod = pyMod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int options, Runnable runner) {
        Object object = this.d_pyMod.getLockObj();
        synchronized (object) {
            if (!this.d_pyMod.isWriteProtected() || PyroTaskManager.test(options, 4)) {
                if (!PyroTaskManager.test(options, 1)) {
                    this.cancelModelessOps();
                }
                this.d_pyMod.pauseUpdates();
                runner.run();
                this.d_pyMod.resumeUpdates();
                if (PyroTaskManager.test(options, 2)) {
                    this.resetCurrentCamera(PyroTaskManager.test(options, 8));
                }
                if (PyroTaskManager.test(options, 32)) {
                    this.selectTool(View.NavTool.SELECT);
                }
            } else {
                this.showPreventModsError();
            }
        }
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }

    @Override
    public void exec(Task tsk, String desc) {
        String logName = PyroTaskManager.getCallSourceName(0);
        this.exec(tsk, desc, logName, 0);
    }

    public void exec(Task tsk, String desc, String logName) {
        this.exec(tsk, desc, logName, 0);
    }

    public void exec(Task tsk, String desc, int options) {
        String logName = PyroTaskManager.getCallSourceName(0);
        this.exec(tsk, desc, logName, options);
    }

    private static String getCallSourceName(int offset) {
        List<StackTraceElement> st = PyroTaskManager.getCallSources(offset + 1, 3);
        if (st.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement el : st) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(el.toString());
        }
        return sb.toString();
    }

    private static List<StackTraceElement> getCallSources(int offset, int maxCount) {
        offset += 2;
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int m = 0; m < stackTrace.length; ++m) {
                StackTraceElement el = stackTrace[m];
                if (!el.getClassName().equals(PyroTaskManager.class.getName()) || !el.getMethodName().equals("getCallSources")) continue;
                ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
                for (int n = m + offset; n < m + offset + maxCount && n < stackTrace.length; ++n) {
                    elements.add(stackTrace[n]);
                }
                return elements;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return Collections.EMPTY_LIST;
    }

    public void exec(final Task tsk, final String desc, String logName, final int options) {
        CrashCatcher.logAction(logName);
        this.run(options, new Runnable(){

            @Override
            public void run() {
                RunWithDependenciesTask runTask = new RunWithDependenciesTask(PyroTaskManager.this.d_pyMod, tsk);
                if (PyroTaskManager.test(options, 16)) {
                    PyroTaskManager.super.run(runTask);
                } else {
                    PyroTaskManager.super.exec(runTask, desc);
                }
            }
        });
    }

    @Override
    public void redo() {
        CrashCatcher.logAction("Redo");
        this.run(0, new Runnable(){

            @Override
            public void run() {
                PyroTaskManager.super.redo();
            }
        });
    }

    @Override
    public void undo() {
        CrashCatcher.logAction("Undo");
        this.run(0, new Runnable(){

            @Override
            public void run() {
                PyroTaskManager.super.undo();
            }
        });
    }

    private void cancelModelessOps() {
        if (PyroSim.getApp().get3DView() != null) {
            PyroSim.getApp().get3DView().cancelCurrentTool();
        }
    }

    private void resetCurrentCamera(boolean retainViewCamera) {
        if (!(PyroSim.getApp().get3DView() == null || retainViewCamera && this.d_pyMod.getViews().getActiveView().get(View.PROP_CAMERA) != null)) {
            PyroSim.getApp().get3DView().resetCurrentCamera();
        }
    }

    private void selectTool(View.NavTool tool) {
        if (PyroSim.getApp().get3DView() != null) {
            PyroSim.getApp().get3DView().setNavTool(tool);
        }
    }

    private void showPreventModsError() {
        PyroSim app = PyroSim.getApp();
        JFrame mainFrame = app.getMainFrame();
        JOptionPane.showMessageDialog(mainFrame, "This model is write-protected. Operation aborted.");
    }

    private static class RunWithDependenciesTask
    implements Task {
        private final PyroMod d_domain;
        private final Task d_baseTask;
        private List<Task> d_updateTasks;

        public RunWithDependenciesTask(PyroMod domain, Task baseTask) {
            this.d_domain = domain;
            this.d_baseTask = baseTask;
            this.d_updateTasks = new ArrayList<Task>();
        }

        @Override
        public boolean canUndo() {
            return this.d_baseTask.canUndo();
        }

        @Override
        public int getEst() {
            return this.d_baseTask.getEst();
        }

        @Override
        public void run() {
            int m;
            Events events = this.d_domain.getEvents();
            IdentityHashSet closedObjs = Collections.EMPTY_SET;
            CompositeTask<PyroMod> task = this.d_baseTask;
            int maxIterations = 10;
            for (m = 0; m < 10; ++m) {
                task.run();
                this.d_domain.updateGeom();
                if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED)) break;
                ArrayList<IPyroObject> changedObjs = new ArrayList<IPyroObject>();
                IEventRecord<IPyroObject> pyroEvents = events.getEvents(IPyroObject.class, new Class[0]);
                for (IPyroObject obj : pyroEvents.getChangedNotOfType(PyroMod.EVT_SEL)) {
                    if (closedObjs.contains(obj) || !TVEntryPoints.ep(obj).getDependentsMayNeedUpdate(this.d_domain, obj)) continue;
                    changedObjs.add(obj);
                }
                if (changedObjs.isEmpty()) break;
                ArrayList<Task> updateTasks = new ArrayList<Task>();
                DepSnapshot ds = this.d_domain.getDependencies(changedObjs);
                for (IPyroObject changedObj : changedObjs) {
                    Set<IDirectDependent> dependents = ds.findAllDependents(IDirectDependent.class, (Object)changedObj);
                    if (dependents.isEmpty()) continue;
                    ArrayList<Object> objChanges = new ArrayList<Object>();
                    pyroEvents.getChanges(changedObj, objChanges);
                    for (IDirectDependent dep : dependents) {
                        Task updateDepTask = dep.taskUpdateDep(changedObj, objChanges);
                        if (updateDepTask == EmptyTask.INSTANCE) continue;
                        updateTasks.add(updateDepTask);
                    }
                }
                if (updateTasks.isEmpty()) break;
                CompositeTask<PyroMod> ct = new CompositeTask<PyroMod>(this.d_domain);
                for (Task t : updateTasks) {
                    ct.addTask(t);
                }
                task = ct;
                if (m == 0) {
                    closedObjs = new IdentityHashSet();
                }
                closedObjs.addAll(changedObjs);
                this.d_updateTasks.add(task);
            }
            if (System.getProperty("dev") != null) {
                System.out.println("num update iterations = " + m);
            }
            if (m == 10) {
                assert (false);
                System.err.println("Dependency update halted early - took too many iterations.");
            }
        }

        @Override
        public void undo() {
            for (int m = this.d_updateTasks.size() - 1; m >= 0; --m) {
                this.d_updateTasks.get(m).undo();
            }
            this.d_baseTask.undo();
        }
    }

    public static interface BypassWriteProtection {
    }
}

