/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import pyrosim.domain.INamed;
import thunderheadeng.util.Filters;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.NamesDB;
import thunderheadeng.util.theUtil;

public class PyroNamesDB
extends NamesDB {
    private static final long serialVersionUID = 6720933778221151162L;

    public <T extends INamed> List<String> generateValidNames(Collection<T> objs, final String baseName, final boolean objsInModel) {
        return this.generateNames(objs, new NamesDB.INameGen<T>(){

            @Override
            public List<String> generate(NameGenerator gen, List<T> list) {
                HashSet<String> currNames = new HashSet<String>();
                if (objsInModel) {
                    for (INamed obj : list) {
                        currNames.add(obj.getName());
                    }
                }
                Predicate<String> acceptNames = Filters.accept(currNames);
                return gen.generateValidNames(list.size(), baseName, acceptNames);
            }
        });
    }

    public <T extends INamed> List<String> generateValidNames(Collection<T> objs, final boolean objsInModel) {
        return this.generateNames(objs, new NamesDB.INameGen<T>(){

            @Override
            public List<String> generate(NameGenerator gen, List<T> list) {
                HashSet<String> currNames = new HashSet<String>();
                if (objsInModel) {
                    for (INamed obj : list) {
                        currNames.add(obj.getName());
                    }
                }
                Predicate<String> acceptNames = s -> currNames.contains(s);
                if (PyroNamesDB.getUniformNames(list)) {
                    return gen.generateValidNames(list.size(), ((INamed)list.get(0)).getName(), acceptNames);
                }
                HashSet<String> newNamesSet = new HashSet<String>();
                Predicate<String> rejectNames = s -> !newNamesSet.contains(s);
                ArrayList<String> newNames = new ArrayList<String>(list.size());
                for (INamed obj : list) {
                    String name = gen.generateValidNames(1, obj.getName(), acceptNames, rejectNames).get(0);
                    newNames.add(name);
                    newNamesSet.add(name);
                    currNames.remove(name);
                }
                return newNames;
            }
        });
    }

    private static boolean getUniformNames(List<? extends INamed> objs) {
        if (objs.isEmpty()) {
            return true;
        }
        String name = objs.get(0).getName();
        for (int m = 1; m < objs.size(); ++m) {
            if (theUtil.equal(name, objs.get(m).getName())) continue;
            return false;
        }
        return true;
    }
}

