/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.Version;
import pyrosim.gui.MpiUtil;

public class FDSVersion
implements Comparable<FDSVersion> {
    private static final Logger LOGGER = Logger.getLogger(FDSVersion.class.getName());
    private static final Pattern PATTERN_V6_7 = Pattern.compile("Revision\\s+:\\s+FDS([0-9]).([0-9]).([0-9])");
    private static final Pattern PATTERN_V612 = Pattern.compile(" Version          : FDS ([0-9]).([0-9]).([0-9])");
    public static final FDSVersion V5_0_0 = new FDSVersion(5, 0, 0, 0);
    public static final FDSVersion V5_5_0 = new FDSVersion(5, 5, 0, 0);
    public static final FDSVersion V5_5_2 = new FDSVersion(5, 5, 2, 0);
    public static final FDSVersion V5_5_3 = new FDSVersion(5, 5, 3, 0);
    public static final FDSVersion V6_0_0_3 = new FDSVersion(6, 0, 0, 3);
    public static final FDSVersion V6_0_0 = new FDSVersion(6, 0, 0, 0);
    public static final FDSVersion V6_0_1 = new FDSVersion(6, 0, 1, 0);
    public static final FDSVersion V6_1_0 = new FDSVersion(6, 1, 0, 0);
    public static final FDSVersion V6_1_1 = new FDSVersion(6, 1, 1, 0);
    public static final FDSVersion V6_1_2 = new FDSVersion(6, 1, 2, 0);
    public static final FDSVersion V6_2_0 = new FDSVersion(6, 2, 0, 0);
    public static final FDSVersion V6_3_0 = new FDSVersion(6, 3, 0, 0);
    public static final FDSVersion V6_3_1 = new FDSVersion(6, 3, 1, 0);
    public static final FDSVersion V6_3_2 = new FDSVersion(6, 3, 2, 0);
    public static final FDSVersion V6_4_0 = new FDSVersion(6, 4, 0, 0);
    public static final FDSVersion V6_5_1 = new FDSVersion(6, 5, 1, 0);
    public static final FDSVersion V6_5_3 = new FDSVersion(6, 5, 3, 0);
    public static final FDSVersion V6_6_0 = new FDSVersion(6, 6, 0, 0);
    public static final FDSVersion V6_7_0 = new FDSVersion(6, 7, 0, 0);
    public static final FDSVersion V6_7_1 = new FDSVersion(6, 7, 1, 0);
    public static final FDSVersion V6_7_3 = new FDSVersion(6, 7, 3, 0);
    public final int major;
    public final int minor;
    public final int maintenance;
    public final int rc;

    public static Collection<FDSVersion> getSupported() {
        return Arrays.asList(Version.FDS_DESIGN);
    }

    public FDSVersion(int major, int minor, int maintenance, int rc) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.rc = rc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FDSVersion)) {
            return false;
        }
        FDSVersion fv = (FDSVersion)obj;
        return fv.major == this.major && fv.minor == this.minor && fv.maintenance == this.maintenance && fv.rc == this.rc;
    }

    @Override
    public int compareTo(FDSVersion o) {
        if (this.major == o.major) {
            if (this.minor == o.minor) {
                if (this.maintenance == o.maintenance) {
                    return this.rc - o.rc;
                }
                return this.maintenance - o.maintenance;
            }
            return this.minor - o.minor;
        }
        return this.major - o.major;
    }

    public static FDSVersion parse(String str) throws ParseException {
        Matcher m67 = PATTERN_V6_7.matcher(str);
        if (m67.find()) {
            String major = m67.group(1);
            String minor = m67.group(2);
            String maint = m67.group(3);
            int imajor = Integer.parseInt(major);
            int iminor = Integer.parseInt(minor);
            int imaint = Integer.parseInt(maint);
            return new FDSVersion(imajor, iminor, imaint, 0);
        }
        Matcher m612 = PATTERN_V612.matcher(str);
        if (m612.find()) {
            String major = m612.group(1);
            String minor = m612.group(2);
            String maint = m612.group(3);
            int imajor = Integer.parseInt(major);
            int iminor = Integer.parseInt(minor);
            int imaint = Integer.parseInt(maint);
            return new FDSVersion(imajor, iminor, imaint, 0);
        }
        if (str.startsWith("Version:")) {
            int sepchar = str.indexOf(59);
            String verstr = str.substring(9, sepchar).trim().toLowerCase();
            boolean versionIsReleaseCandidate = (verstr = verstr.replace("fds", "")).contains("release candidate");
            if (versionIsReleaseCandidate) {
                verstr = verstr.replace("release candidate", "");
            }
            StringTokenizer strtok = new StringTokenizer(verstr, " ,.;");
            ArrayDeque<String> vernums = new ArrayDeque<String>();
            while (strtok.hasMoreTokens()) {
                vernums.add(strtok.nextToken());
            }
            int major = 0;
            int minor = 0;
            int maint = 0;
            int rc = 0;
            major = Integer.parseInt((String)vernums.removeFirst());
            if (versionIsReleaseCandidate) {
                rc = Integer.parseInt((String)vernums.removeLast());
            }
            if (!vernums.isEmpty()) {
                minor = Integer.parseInt((String)vernums.removeFirst());
            }
            if (!vernums.isEmpty()) {
                maint = Integer.parseInt((String)vernums.removeFirst());
            }
            return new FDSVersion(major, minor, maint, rc);
        }
        throw new ParseException(Intl.intl("Could not parse FDS version."), 0);
    }

    public String toString() {
        if (this.rc == 0) {
            return String.format("Version %d.%d.%d", this.major, this.minor, this.maintenance);
        }
        if (this.minor == 0 && this.maintenance == 0) {
            return String.format("Version %d RC%d", this.major, this.rc);
        }
        if (this.maintenance == 0) {
            return String.format("Version %d.%d RC%d", this.major, this.minor, this.rc);
        }
        return String.format("Version %d.%d.%d RC%d", this.major, this.minor, this.maintenance, this.rc);
    }

    public static FDSVersion detectCompability(File exeLoc) throws Exception {
        if (!exeLoc.exists()) {
            throw new IOException(String.format(Intl.intl("File not found: %s"), exeLoc.getAbsolutePath()));
        }
        ProcessBuilder pb = new ProcessBuilder(exeLoc.getPath());
        MpiUtil.scrubEnvMpi(pb.environment());
        File mpiFolder = new File(PyroPrefs.getMPIExecLocation()).getParentFile();
        pb.environment().put("PATH", MpiUtil.buildEnvPath("", mpiFolder.getPath()));
        Process p = pb.start();
        FDSVersion[] result = new FDSVersion[]{null};
        TextMonitor errMonitor = new TextMonitor(result, p.getErrorStream());
        TextMonitor inMonitor = new TextMonitor(result, p.getInputStream());
        errMonitor.start();
        inMonitor.start();
        p.waitFor();
        if (result[0] == null) {
            if (errMonitor.d_caughtException != null) {
                throw errMonitor.d_caughtException;
            }
            if (inMonitor.d_caughtException != null) {
                throw inMonitor.d_caughtException;
            }
            throw new IOException(String.format(Intl.intl("Could not determine FDS version from executable: %n%s."), exeLoc.getAbsoluteFile()));
        }
        return result[0];
    }

    private static class TextMonitor
    extends Thread {
        private final FDSVersion[] d_result;
        private final InputStream d_stream;
        private IOException d_caughtException;

        public TextMonitor(FDSVersion[] result, InputStream stream) {
            this.d_result = result;
            this.d_stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder attempts = new StringBuilder();
            try {
                String line;
                FDSVersion[] inputReader = new InputStreamReader(this.d_stream);
                BufferedReader reader = new BufferedReader((Reader)inputReader);
                while ((line = reader.readLine()) != null) {
                    LOGGER.info(line);
                    if (this.d_result[0] != null) continue;
                    try {
                        FDSVersion comp;
                        this.d_result[0] = comp = FDSVersion.parse(line);
                    }
                    catch (Exception e) {
                        if (line == null || line.trim().length() == 0) continue;
                        attempts.append(String.format("%s: %s (%s)%n", e.getClass().getName(), e.getMessage(), line));
                    }
                }
                if (this.d_result[0] == null) {
                    throw new IOException("Unable to detect version.");
                }
            }
            catch (IOException e) {
                if (attempts.length() == 0) {
                    System.err.printf("%s: %s%n", e.getClass().getName(), e.getMessage());
                } else {
                    System.err.println(attempts.toString());
                }
                this.d_caughtException = e;
            }
            finally {
                FDSVersion[] fDSVersionArray = this.d_result;
                synchronized (this.d_result) {
                    try {
                        this.d_result.notify();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

