@echo off

if NOT "x%1%" == "x" goto skip_usage
  call :usage
  exit /b
:skip_usage

set n_mpi=1
set n_openmp=1
set show_only=0
set stop_script=0
set use_openmp=0
set have_casename=0

call :getopts %*
if "%stop_script%" == "1" exit /b
call :set_openmp_defaults

if "%have_casename%" == "1" goto skip_casename_test
  echo ***error: an input file is missing
  call :usage
  echo .
  if "%show_only%" == "1" goto skip_casename_test
  exit /b
:skip_casename_test

set ECHO=
if "%show_only%" == "1" set ECHO=echo
%ECHO% mpiexec -localonly -n %n_mpi% -env OMP_NUM_THREADS %n_openmp% fds %casename%

:eof
exit /b

:-------------------------------------------------------------------------
:----------------------subroutines----------------------------------------
:-------------------------------------------------------------------------

:-------------------------------------------------------------------------
:getopts
:-------------------------------------------------------------------------
 if (%1)==() exit /b

 set casename=%1
 set case1=%casename:~0,1%
 if "%case1%" == "-" goto skip_casename

   set have_casename=1
   if EXIST %casename% goto skip_casename_notexist
   if "%show_only%" == "1" goto skip_casename_notexist
      echo ***error: The input file %casename% does not exist
      set stop_script=1

 :skip_casename_notexist
 exit /b

 :skip_casename
 set valid=0
 set arg=%1
 if /I "%1" EQU "-p" (
   set valid=1
   set n_mpi=%2
   shift
 )
 if /I "%1" EQU "-v" (
   set valid=1
   set show_only=1
 )
 if /I "%1" EQU "-h" (
   set valid=1
   set stop_script=1
   call :usage
   exit /b
 )
 if /I "%1" EQU "-o" (
   set valid=1
   set n_openmp=%2
   set use_openmp=1
   shift
 )
 shift
 if %valid% == 0 (
   echo.
   echo ***Error: the input argument %arg% is invalid
   echo.
   echo Usage:
   call :usage
   set stop_script=1
   exit /b
 )
if not (%1)==() goto getopts
exit /b

:-------------------------------------------------------------------------
:set_openmp_defaults
:-------------------------------------------------------------------------
:: if number of openmp threads are not specified then
:: set number of openmp threads to 1 if number of mpi processes > 1
:: set number of openmp threads to %OMP_NUM_THREADS% if number of mpi processes = 1

if "%use_openmp%" == "1" exit /b
if "%n_mpi%" == "1" set n_openmp=%OMP_NUM_THREADS%
if "%n_mpi%" == "1" exit /b
set n_openmp=1
exit /b

:-------------------------------------------------------------------------
:usage  
:-------------------------------------------------------------------------
echo.
echo Usage:
echo fds_local  [options] casename.fds
echo.
echo options:
echo -h    - display this message only
echo -p xx - number of MPI processes [default: 1]
echo -o yy - number of OpenMP threads per process [default: %OMP_NUM_THREADS% if xx=1; 1 if xx^>1]
echo -v    - show command line generated by this script (fds is not run)

exit /b
