/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.unitsystem;

import java.util.HashMap;
import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.units.UnitDouble;

public class SIUS
extends UnitSystem {
    private static final Map<Integer, Unit> s_unitMap = new HashMap<Integer, Unit>();
    private static final SIUS s_fdsSystem;

    public SIUS() {
        super(Intl.intl("SI"));
    }

    public static SIUS getInstance() {
        return s_fdsSystem;
    }

    @Override
    public Unit getUnit(int type) {
        return s_unitMap.get(type);
    }

    public static Unit unit(int type) {
        return s_unitMap.get(type);
    }

    public static UnitDouble newud(double val, int id) {
        return new UnitDouble(val, SIUS.unit(id));
    }

    static {
        s_unitMap.put(0, (Unit)SI.METER);
        s_unitMap.put(1, SI.CELSIUS);
        s_unitMap.put(2, (Unit)SI.SECOND);
        s_unitMap.put(7, SI.PASCAL);
        s_unitMap.put(12, NonSI.BAR);
        s_unitMap.put(29, NonSI.DEGREE_ANGLE);
        s_unitMap.put(3, SI.METER.multiply((Unit)SI.SECOND).root(2).label("<html>&#8730(m&#183s)</html>"));
        s_unitMap.put(4, SI.KILOGRAM.divide(SI.METER.pow(3)));
        s_unitMap.put(5, SI.KELVIN.divide((Unit)SI.METER));
        s_unitMap.put(6, SI.METER.divide(SI.SECOND.pow(2)));
        s_unitMap.put(8, SI.METER.divide((Unit)SI.SECOND));
        s_unitMap.put(9, SI.MILLI((Unit)SI.METER));
        s_unitMap.put(10, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM));
        s_unitMap.put(11, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM).divide((Unit)SI.KELVIN));
        s_unitMap.put(13, SI.METER.pow(-1));
        s_unitMap.put(15, SI.KILO((Unit)SI.JOULE).divide(SI.KILO((Unit)SI.MOLE)));
        s_unitMap.put(16, (Unit)SI.METER);
        s_unitMap.put(17, SI.GRAM.divide((Unit)SI.MOLE));
        s_unitMap.put(18, Unit.ONE.alternate("kg/kg"));
        s_unitMap.put(27, SI.METER.pow(2).divide((Unit)SI.SECOND));
        s_unitMap.put(19, SI.WATT.divide((Unit)SI.METER).divide((Unit)SI.KELVIN));
        s_unitMap.put(81, SI.WATT.divide(SI.METER.pow(2)).divide((Unit)SI.KELVIN));
        s_unitMap.put(20, SI.KILOGRAM.divide(SI.METER.pow(2)).divide((Unit)SI.SECOND));
        s_unitMap.put(21, SI.METER.pow(2).divide(SI.KILOGRAM.divide((Unit)SI.SECOND)));
        s_unitMap.put(88, SI.KILO((Unit)SI.WATT).divide((Unit)SI.METER));
        s_unitMap.put(22, SI.KILO((Unit)SI.WATT).divide(SI.METER.pow(2)));
        s_unitMap.put(25, SI.KILO((Unit)SI.WATT).divide(SI.METER.pow(3)));
        s_unitMap.put(23, SI.KILOGRAM.divide(SI.METER.pow(2)));
        s_unitMap.put(24, SI.METER.pow(3).divide((Unit)SI.SECOND));
        s_unitMap.put(26, Unit.ONE.alternate("kg/kg"));
        s_unitMap.put(28, Unit.ONE);
        s_unitMap.put(31, NonSI.PERCENT.divide((Unit)SI.METER));
        s_unitMap.put(34, Unit.ONE.divide((Unit)SI.METER).label("1/m"));
        s_unitMap.put(30, NonSI.LITER.divide(NonSI.MINUTE));
        s_unitMap.put(32, Unit.ONE.alternate("mol/mol"));
        s_unitMap.put(33, SI.KILO((Unit)SI.WATT).divide(SI.METER.pow(2)));
        s_unitMap.put(35, SI.SECOND.pow(-1));
        s_unitMap.put(36, SI.METER.divide((Unit)SI.SECOND).pow(2));
        s_unitMap.put(37, SI.KILO((Unit)SI.WATT));
        s_unitMap.put(38, SI.KILOGRAM.divide((Unit)SI.SECOND));
        s_unitMap.put(39, SI.PASCAL);
        s_unitMap.put(40, SI.MILLI((Unit)SI.GRAM).divide(SI.METER.pow(3)));
        s_unitMap.put(41, SI.KILOGRAM.divide((Unit)SI.METER).divide((Unit)SI.SECOND));
        s_unitMap.put(42, NonSI.ANGSTROM);
        s_unitMap.put(43, (Unit)SI.KELVIN);
        s_unitMap.put(44, SI.KILOGRAM.divide(SI.METER.pow(2)).divide((Unit)SI.SECOND));
        s_unitMap.put(45, SI.KILOGRAM.divide(SI.METER.pow(2)).divide((Unit)SI.SECOND));
        s_unitMap.put(46, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM));
        s_unitMap.put(47, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM));
        s_unitMap.put(48, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM));
        s_unitMap.put(50, SI.SECOND.pow(-1).label("1/s"));
        s_unitMap.put(51, SI.METER.pow(-1).label("1/m"));
        s_unitMap.put(52, SI.METER.pow(2).divide((Unit)SI.KILOGRAM));
        s_unitMap.put(53, Unit.ONE.divide((Unit)SI.SECOND));
        s_unitMap.put(54, SI.KILO((Unit)SI.JOULE).divide(SI.KILO((Unit)SI.MOLE)));
        s_unitMap.put(55, Unit.ONE.alternate(Intl.intl("Droplets")).divide(SI.METER.pow(3)));
        s_unitMap.put(56, SI.METER.pow(3));
        s_unitMap.put(57, NonSI.PERCENT);
        s_unitMap.put(58, NonSI.LITER.divide(NonSI.MINUTE).divide(NonSI.ATMOSPHERE.root(2)));
        s_unitMap.put(59, NonSI.ATMOSPHERE);
        s_unitMap.put(60, SI.METER.divide((Unit)SI.SECOND).root(2).label("<html>&#8730(m/s)</html>"));
        s_unitMap.put(61, SI.MICRO((Unit)SI.METER));
        s_unitMap.put(62, SI.KILO((Unit)SI.JOULE).divide(SI.METER.pow(3)));
        s_unitMap.put(63, Unit.ONE.divide((Unit)SI.METER));
        s_unitMap.put(64, NonSI.PERCENT);
        s_unitMap.put(65, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM));
        s_unitMap.put(66, SI.KILOGRAM.multiply(SI.METER.pow(2)));
        s_unitMap.put(67, SI.NEWTON);
        s_unitMap.put(68, SI.CENTI((Unit)SI.METER).pow(2));
        s_unitMap.put(69, SI.NEWTON.divide(SI.METER.divide((Unit)SI.SECOND)));
        s_unitMap.put(70, Unit.ONE.alternate("rps"));
        s_unitMap.put(71, Unit.ONE.alternate("pers").divide(SI.METER.pow(2)));
        s_unitMap.put(72, Unit.ONE.alternate("pers").divide((Unit)SI.SECOND));
        s_unitMap.put(73, Unit.ONE.divide((Unit)SI.SECOND).alternate("<html>m<sup>2</sup>/(sm<sup>2</sup>)</html>"));
        s_unitMap.put(74, SI.KELVIN.divide(NonSI.MINUTE));
        s_unitMap.put(75, SI.KILOGRAM.divide((Unit)SI.METER));
        s_unitMap.put(76, SI.KILOGRAM.divide((Unit)SI.SECOND));
        s_unitMap.put(77, (Unit)SI.KILOGRAM);
        s_unitMap.put(78, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.SECOND));
        s_unitMap.put(79, SI.METER.pow(2));
        s_unitMap.put(80, NonSI.PERCENT);
        s_unitMap.put(82, Unit.ONE.alternate("ppm"));
        s_unitMap.put(83, SI.KILOGRAM.divide(SI.METER.pow(2)));
        s_unitMap.put(84, NonSI.PERCENT);
        s_unitMap.put(85, Unit.ONE);
        s_unitMap.put(86, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.MOLE));
        s_unitMap.put(87, Unit.ONE.alias("<html>m<sup>3</sup>/m<sup>3</sup></html>"));
        s_unitMap.put(89, SI.WATT.divide(SI.GRAM));
        s_unitMap.put(90, SI.MICRO((Unit)SI.METER));
        s_unitMap.put(92, SI.PASCAL.divide((Unit)SI.METER));
        s_unitMap.put(93, (Unit)SI.KELVIN);
        s_fdsSystem = new SIUS();
    }
}

