/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import pyrosim.PyroMod;
import pyrosim.treeview.PyroTreeView;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;

public class PyroTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 4780035454933164803L;
    private final PyroTreeView d_treeView;
    private final PyroMod d_mediator;

    public PyroTreeCellRenderer(PyroTreeView ptv, PyroMod mediator) {
        this.d_treeView = ptv;
        this.d_mediator = mediator;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, "", selected, expanded, leaf, row, hasFocus);
        PyroTreeCellRenderer.decorateLabel(this.d_mediator, this, value);
        return this;
    }

    public static void decorateLabel(PyroMod domain, JLabel label, Object value) {
        TVEntryPoint<Object> ep = TVEntryPoints.ep(value);
        String name = ep.getDisplayName(value);
        label.setText(name);
        String tt = ep.getTooltip(value);
        if (!tt.isEmpty()) {
            label.setToolTipText(tt);
        } else {
            label.setToolTipText(null);
        }
        label.setFont(ep.getFont(domain, value));
        Icon[] icons = ep.getIcons(domain, value);
        label.setIcon(icons[0]);
        label.setDisabledIcon(icons[1]);
        boolean enabled = true;
        enabled &= ep.isEnabled(domain, value);
        label.setEnabled(enabled &= ep.isVisible(domain, value));
    }
}

