/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.mv.ModelView;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.tools.ATransformTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.MouseHistory;

public class TranslateTool
extends ATransformTool
implements ValueEditor.IListener {
    public TranslateTool(ModelView mv, TransformMgr xformMgr, ModelScene toolScene, DrawProps props) {
        super(mv, xformMgr, toolScene, props);
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        super.initValueEditor(editor);
        ValueEditorUtil.configure(editor, "LOCATION", "OFFSET");
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        List<Point3d> points = this.getClickHistory().getAllPoints();
        Point3d p1 = points.size() >= 1 ? points.get(0) : null;
        Point3d p2 = points.size() >= 2 ? p.p : null;
        this.update(p1, p2);
        if (history.committedSize() >= 2) {
            this.finishIfValid();
        }
    }

    public void finishIfValid() {
        if (this.getXformMgr().isTransformValid()) {
            super.finish();
        }
    }

    private void update(Point3d p1, Point3d p2) {
        IPrimProps.GenericProps dprops = new IPrimProps.GenericProps(Color.RED, null, 3.0, IPrimProps.DEF_STIPPLE, 10.0, 0);
        ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
        if (p2 != null) {
            geoms.add(new LineSeg(p1, p2));
        }
        if (p1 != null) {
            geoms.add(new Point(p1));
        }
        this.updateToolDisplay(GeomNodeUtil.newNode(new GeomGroup(geoms)), new UniformProps(dprops));
        if (p2 != null) {
            Vector3d dir = Util3D.vector(p1, p2);
            ITransform xform = TransformUtil.translate(dir.x, dir.y, dir.z);
            this.getXformMgr().modify(xform);
        } else {
            this.getXformMgr().modify(TransformUtil.IDENTITY);
        }
        this.repaintSurface();
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }
}

