/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.function.Function;
import javax.vecmath.Point2d;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.MouseSelectionLogic;
import pyrosim.mv.snappers.ModelGridSnapper;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelectionLogic;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.theUtil;

public class Pyro3DSelector
implements ISelectionLogic {
    private final MouseSelectionLogic d_selLogic;

    public Pyro3DSelector(MouseSelectionLogic selLogic) {
        this.d_selLogic = selLogic;
    }

    public IIsectFilter getSelectionFilter(CursorTool tool) {
        if (this.gridSelEnabled(tool)) {
            return new DefaultFilter(IPyroObject.class, ModelGridSnapper.class);
        }
        return new DefaultFilter(IPyroObject.class);
    }

    private boolean gridSelEnabled(CursorTool tool) {
        return tool.isKeyPressed(71);
    }

    @Override
    public void selectSingle(CursorTool tool, MouseEvent e, Point2d viewPoint, GeomPicker picker) {
        Collection<IsectInfo> isects = ISelectionLogic.find(tool, picker, viewPoint, this.getSelectionFilter(tool));
        this.d_selLogic.handleSelectionSingle(e, tool.getPressedKeys(), Pyro3DSelector.transformGrids(Pyro3DSelector.transformIsects(isects)));
    }

    @Override
    public void selectMultiple(CursorTool tool, MouseEvent e, Point2d viewPoint1, Point2d viewPoint2, GeomPicker picker) {
        Collection<Object> objects = ISelectionLogic.find(tool, picker, viewPoint1, viewPoint2, this.getSelectionFilter(tool));
        this.d_selLogic.handleSelectionMultiple(e, tool.getPressedKeys(), Pyro3DSelector.transformGrids(objects));
    }

    private static Collection<Object> transformGrids(Collection<Object> objs) {
        Function<Object, Object> transformer = new Function<Object, Object>(){

            @Override
            public Object apply(Object obj) {
                if (obj instanceof ModelGridSnapper) {
                    return ((ModelGridSnapper)obj).getGrid();
                }
                return obj;
            }
        };
        return theUtil.map(objs, transformer);
    }

    private static Collection<Object> transformIsects(Collection<IsectInfo> isects) {
        return theUtil.map(isects, new Function<IsectInfo, Object>(){

            @Override
            public Object apply(IsectInfo obj) {
                return obj.obj;
            }
        });
    }
}

