/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import javax.vecmath.Matrix4d;
import pyrosim.domain.ModelImage;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.scene3d.nativebuffered.NativeImage;
import thunderheadeng.scene3d.nativebuffered.NativeImageMgr;
import thunderheadeng.scene3d.nativebuffered.RasterObj;

public class ModelImageDisplay
extends RasterObj {
    private static final long serialVersionUID = -7419143294092489031L;
    private ModelImage d_image;

    public ModelImageDisplay(ModelImage image) {
        this.setImage(image);
    }

    public void setImage(ModelImage img) {
        this.d_image = img;
        this.update();
    }

    public ModelImage getObject() {
        return this.d_image;
    }

    public void update() {
        IImage oldImg;
        Image newImg = this.d_image != null ? this.d_image.getImage() : null;
        IImage iImage = oldImg = super.getImage() != null ? super.getImage().getBaseImage() : null;
        if (newImg != oldImg) {
            NativeImage nimg = newImg != null ? NativeImageMgr.getImage(newImg) : null;
            super.setImage(nimg);
        }
        if (this.d_image != null) {
            Matrix4d xform = this.d_image.getLWTransform().toMatrix(true);
            this.setTransform(xform);
            this.setColor(new Color(1.0f, 1.0f, 1.0f, this.d_image.getOpacity()));
        }
    }
}

