/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.PyroSimColors;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.geom.Geometry;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.geom.Util;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeMirroredHelper;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.NativeMaterial;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Keyable;
import thunderheadeng.util.theUtil;

public class GridDisplay
extends Object3D
implements IPyroDisplay,
IDisplayable,
INativelyMirrored {
    private static final long serialVersionUID = -8831175380220269835L;
    private static final int method_setSelected = 0;
    private static final int method_setVisible = 1;
    private static final Point3d[] s_emptyP3dArr = new Point3d[0];
    private static final int[] s_emptyIntArr = new int[0];
    private final Grid d_grid;
    private Floor d_activeFloor;
    private NativeMaterial d_boundaryDisp;
    private Surface d_surface;
    private boolean d_outlineVis;
    private boolean d_meshVis;
    private boolean d_boundaryVis;
    private Color d_outlineColor;
    private Color d_meshColor;
    private boolean d_selected = false;
    private final NativeMirroredHelper d_mirrorHelper = new NativeMirroredHelper(this);
    private DisplayData d_dispData;

    public GridDisplay(Grid g, NativeMaterial boundaryDisp, Surface surface) {
        this.d_grid = g;
        this.d_activeFloor = null;
        this.d_boundaryDisp = boundaryDisp;
        this.d_surface = surface;
        this.d_meshVis = true;
        this.d_outlineVis = true;
        this.d_dispData = new DisplayData();
        this.updateColors();
        this.nativeConstructed(GridDisplay.class);
    }

    @Override
    public Class resolveNativeClass() {
        return GridDisplay.class;
    }

    @Override
    public void getDisplayObjs(RenderTarget target, Collection<? super IDisplayable> displays) {
        switch (target) {
            case NORMAL: {
                displays.add(this);
            }
        }
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        writer.writeBoolean(this.d_selected);
        Unit lu = Geometry.LU;
        Point3d min = this.d_grid.getMinPoint().getPoint3dValue(lu);
        Point3d max = this.d_grid.getMaxPoint().getPoint3dValue(lu);
        if (this.d_activeFloor != null) {
            double bottom = this.d_activeFloor.getSlabBottom().getValue(Geometry.LU);
            double top = this.d_activeFloor.getCeilingLoc().getValue(Geometry.LU);
            if (theUtil.gt(bottom, min.z, 1.0E-9)) {
                min.z = bottom;
            }
            if (theUtil.lt(top, max.z, 1.0E-9)) {
                max.z = top;
            }
            if (max.z < min.z) {
                min.z = max.z;
            }
        }
        writer.writeDoubles(min.x, min.y, min.z);
        writer.writeDoubles(max.x, max.y, max.z);
        double[] xlines = Util.convertArray(this.d_grid.getXLinePositions(), lu);
        double[] ylines = Util.convertArray(this.d_grid.getYLinePositions(), lu);
        double[] zlines = Util.convertArray(this.d_grid.getZLinePositions(), lu);
        writer.writeInt(xlines.length);
        writer.writeDoubles(xlines);
        writer.writeInt(ylines.length);
        writer.writeDoubles(ylines);
        writer.writeInt(zlines.length);
        writer.writeDoubles(zlines);
        writer.write((Keyable)this.d_boundaryDisp);
        writer.writeInt(this.d_dispData.verts.length);
        for (int m = 0; m < this.d_dispData.verts.length; ++m) {
            GridDisplay.writeAsP3f(writer, this.d_dispData.verts[m]);
        }
        writer.writeInt(this.d_dispData.tris.length);
        writer.writeInts(this.d_dispData.tris);
        writer.writeInt(this.d_dispData.texuv.length);
        for (Point2d p2d : this.d_dispData.texuv) {
            writer.writeFloat((float)p2d.x);
            writer.writeFloat((float)p2d.y);
        }
        writer.writeInt(this.d_dispData.boundaryLines.length);
        writer.writeInts(this.d_dispData.boundaryLines);
        writer.writeBooleans(this.d_boundaryVis, this.d_outlineVis, this.d_meshVis);
        Color gridColor = this.d_grid.getColor();
        Color outlineColor = gridColor != null ? gridColor : this.d_outlineColor;
        Color meshColor = gridColor != null ? gridColor : this.d_meshColor;
        Color faceColor = this.d_surface.getColor();
        writer.writeFloats(outlineColor.getComponents(new float[4]));
        writer.writeFloats(meshColor.getComponents(new float[4]));
        writer.writeFloats(faceColor.getComponents(new float[4]));
    }

    private static void writeAsP3f(INativeStream stream, Point3d p) {
        stream.writeFloats((float)p.x, (float)p.y, (float)p.z);
    }

    @Override
    public void update() {
        this.markNativeDirty();
    }

    @Override
    public void markNativeDirty() {
        this.d_mirrorHelper.markNativeDirty();
    }

    public void pauseUpdates() {
        this.d_mirrorHelper.pauseUpdates();
    }

    public void resumeUpdates() {
        this.d_mirrorHelper.resumeUpdates();
    }

    @Override
    public void markNativeClean() {
        this.d_mirrorHelper.markNativeClean();
    }

    public void setActiveFloor(Floor floor) {
        if (this.d_activeFloor == floor) {
            return;
        }
        this.d_activeFloor = floor;
        this.update();
    }

    public void updateColors() {
        PyroSimColors colors = ((PyroSim)Application.getApp()).getColorManager();
        this.d_outlineColor = colors.getColor(PyroSimColors.BOUNDARY_LINE_COLOR);
        this.d_meshColor = colors.getColor(PyroSimColors.SNAP_TO_GRID_COLOR);
        this.markNativeDirty();
    }

    public Mesh getSurfaceMesh() {
        return new Mesh(this.d_dispData.verts, this.d_dispData.tris, 2);
    }

    public Mesh getOutlineMesh() {
        return new Mesh(this.d_dispData.verts, this.d_dispData.boundaryLines, 1);
    }

    public static DisplayData generateDisplayData(Collection<Face> faces, Collection<Edge> boundaryEdges, Surface surf) {
        LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
        if (!faces.isEmpty() || !boundaryEdges.isEmpty()) {
            ArrayList<Integer> resultTris = new ArrayList<Integer>();
            for (Face face : faces) {
                face.triangulate(0.0, pointIxMap, resultTris);
            }
            ArrayList<Integer> resultEdges = new ArrayList<Integer>(boundaryEdges.size());
            for (Edge edge : boundaryEdges) {
                Integer i1 = GridDisplay.getIx(pointIxMap, edge.v1.loc);
                Integer i2 = GridDisplay.getIx(pointIxMap, edge.v2.loc);
                resultEdges.add(i1);
                resultEdges.add(i2);
            }
            if (!(pointIxMap.isEmpty() || resultTris.isEmpty() && resultEdges.isEmpty())) {
                Point3d[] point3dArray = pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]);
                int[] tris = theUtil.toIntArray(resultTris);
                int[] boundaryLines = theUtil.toIntArray(resultEdges);
                Object[] texuv = new Point2d[]{};
                if (surf.getAppearance() != null && surf.getAppearance().getAttributes().getTexture(MatChannel.DIFFUSE) != null) {
                    IPrimProps.Face props;
                    UniformProps uprops;
                    Mesh mesh;
                    PlanarCoordMapper texGen = TexCoordGenerator.newGenerator(new Point3d(0.0, 0.0, 0.0));
                    ElementMesh<Point2d> uvmesh = texGen.generate(Point2d.class, mesh = new Mesh(point3dArray, tris, 2), Elements.CW, (IPropsSrc)(uprops = new UniformProps(props = new IPrimProps.Face(surf.getColor(), surf, 0))));
                    if (uvmesh != null) {
                        if (uvmesh.indices == ElementMesh.DIRECT && uvmesh.mapping == ElementMesh.Mapping.PER_PRIM_VERTEX) {
                            assert (((Point2d[])uvmesh.elements).length == tris.length);
                            texuv = (Point2d[])uvmesh.elements;
                        } else {
                            texuv = new Point2d[tris.length];
                            int numPrims = mesh.getNumPrims(7);
                            assert (numPrims == tris.length);
                            int ix = 0;
                            for (int m = 0; m < numPrims; ++m) {
                                for (int n = 0; n < 3; ++n) {
                                    texuv[ix++] = uvmesh.getPrimVertElement(m, n);
                                }
                            }
                        }
                    } else {
                        assert (false);
                        texuv = new Point2d[tris.length];
                        Arrays.fill(texuv, GeomConstants.PNT3D_ORIGIN);
                    }
                }
                return new DisplayData(point3dArray, tris, (Point2d[])texuv, boundaryLines);
            }
        }
        return new DisplayData();
    }

    public void setData(Collection<Face> faces, Collection<Edge> boundaryEdges) {
        this.d_dispData = GridDisplay.generateDisplayData(faces, boundaryEdges, this.d_surface);
        this.markNativeDirty();
    }

    private static Integer getIx(Map<Point3d, Integer> map, Point3d p) {
        Integer ix = map.get(p);
        if (ix == null) {
            ix = map.size();
            map.put(p, ix);
        }
        return ix;
    }

    public void updateOutlineVisible(boolean vis) {
        this.d_outlineVis = vis;
        this.markNativeDirty();
    }

    public void updateMeshVisible(boolean vis) {
        this.d_meshVis = vis;
        this.markNativeDirty();
    }

    public void updateBoundaryVisible(boolean vis) {
        this.d_boundaryVis = vis;
        this.markNativeDirty();
    }

    public void updateSelected(boolean selected) {
        this.d_selected = selected;
        this.markNativeDirty();
    }

    public boolean[] getVisibility() {
        return new boolean[]{this.d_meshVis, this.d_boundaryVis, this.d_outlineVis};
    }

    public void setVisible(boolean outline, boolean boundary, boolean mesh) {
        this.d_outlineVis = outline;
        this.d_meshVis = mesh;
        this.d_boundaryVis = boundary;
        Native.manager.execMethod(GridDisplay.class, (INativeObject)this, 1, this.d_outlineVis, this.d_boundaryVis, this.d_meshVis);
    }

    @Override
    public void setSelected(boolean selected) {
        this.d_selected = selected;
        Native.manager.execMethod(GridDisplay.class, (INativeObject)this, 0, this.d_selected);
    }

    public void updateBoundarySurface(NativeMaterial display, Surface surf) {
        this.d_boundaryDisp = display;
        this.d_surface = surf;
        this.markNativeDirty();
    }

    public Grid getObject() {
        return this.d_grid;
    }

    public Object getSelectionObject() {
        return this.d_grid;
    }

    public static class DisplayData {
        public final Point3d[] verts;
        public final int[] tris;
        public final Point2d[] texuv;
        public final int[] boundaryLines;

        public DisplayData() {
            this(s_emptyP3dArr, s_emptyIntArr, new Point2d[0], s_emptyIntArr);
        }

        public DisplayData(Point3d[] verts, int[] tris, Point2d[] texuv, int[] boundaryLines) {
            this.verts = verts;
            this.tris = tris;
            this.texuv = texuv;
            this.boundaryLines = boundaryLines;
        }

        public IGeomNode getGeom(boolean boundaryEdgesAsCreases) {
            Mesh mesh = this.getSurfaceMesh();
            IElemSource<Point2d> uv = this.getUV();
            IElemSource<Boolean> creases = Elements.ALL_CREASE;
            if (boundaryEdgesAsCreases) {
                HashSet<HashableEdge> bedges = new HashSet<HashableEdge>();
                int m = 0;
                while (m < this.boundaryLines.length) {
                    int i1 = this.boundaryLines[m++];
                    int i2 = this.boundaryLines[m++];
                    bedges.add(new HashableEdge(i1, i2));
                }
                Boolean[] cedges = new Boolean[mesh.indices.length];
                int cedgeix = 0;
                int[] tri = new int[3];
                int m2 = 0;
                while (m2 < mesh.indices.length) {
                    tri[0] = mesh.indices[m2++];
                    tri[1] = mesh.indices[m2++];
                    tri[2] = mesh.indices[m2++];
                    for (int n = 0; n < 3; ++n) {
                        int i1 = tri[n];
                        int i2 = tri[GeomUtil.PLUS1MOD3[n]];
                        cedges[cedgeix++] = bedges.contains(new HashableEdge(i1, i2));
                    }
                }
                creases = new ElementMesh<Boolean>(ElementMesh.Mapping.PER_PRIM_VERTEX, cedges, 3);
            }
            IPropertySet elements = Elements.newElements("teciuv0x193fa", uv, Elements.CREASE, creases);
            return GeomNodeUtil.newNode(mesh, elements);
        }

        public Mesh getSurfaceMesh() {
            return new Mesh(this.verts, this.tris, 2);
        }

        public IElemSource<Point2d> getUV() {
            return new ElementMesh<Point2d>(ElementMesh.Mapping.PER_PRIM_VERTEX, this.texuv, 3);
        }

        public Mesh getOutlineMesh() {
            return new Mesh(this.verts, this.boundaryLines, 1);
        }

        private static class HashableEdge {
            public final int i1;
            public final int i2;

            public HashableEdge(int i1, int i2) {
                this.i1 = i1;
                this.i2 = i2;
            }

            public int hashCode() {
                return this.i1 ^ this.i2;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !obj.getClass().equals(this.getClass())) {
                    return false;
                }
                HashableEdge be = (HashableEdge)obj;
                return this.i1 == be.i1 && this.i2 == be.i2 || this.i1 == be.i2 && this.i2 == be.i1;
            }
        }
    }
}

