/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PyroDisplayGeom;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.ModelView;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theTimer;

public class GeomDisplayMgr
extends APyroDisplayMgr<IPyroGeomSrc, CapDisplay> {
    private final PyroDrawProps d_drawProps;
    private GridMergeUtil.MergeResult d_gridBoundaries;
    private final Predicate<IPyroGeomSrc> d_filter;
    private final boolean d_capsEnabled;

    public GeomDisplayMgr(PyroMod mod, ModelView mv, APyroDisplayMgr.TargetSceneMap scenes, PyroDrawProps drawProps, DisplayFilter df, Predicate<IPyroGeomSrc> filter) {
        super(mod, mv, scenes, df, new IPyroDisplayMgr.ObjFilter<IPyroGeomSrc>(IPyroGeomSrc.class, filter, Grid.class));
        this.d_drawProps = drawProps;
        this.d_filter = filter;
        this.d_capsEnabled = ((Optional)scenes.apply(RenderTarget.CLIP_CAPS)).isPresent();
    }

    protected Composite<? extends IPyroObject>[] getManagers(PyroMod domain) {
        return new Composite[]{domain.getObstructions(), domain.getZoneMgr(), domain.getDevices(), domain.getMsrStatMgr(), domain.getSlcfList(), domain.getSlcf3dList(), domain.getViews()};
    }

    @Override
    protected boolean isSelected(IPyroGeomSrc obj) {
        return this.getMediator().getSelectionModel().isSelected(obj);
    }

    @Override
    public void addAll() {
        for (Composite<? extends IPyroObject> manager : this.getManagers(this.getMediator())) {
            this.addDisplays(manager.flatten(IPyroGeomSrc.class, this.getObjFilter().toTypedPredicate()));
        }
    }

    @Override
    protected CapDisplay createDisplay(IPyroGeomSrc obj, boolean visible, boolean selected) {
        PyroDrawProps dispProps = this.getDrawProps();
        IDisplayableGeomSrc src = this.getSource(obj);
        CapDisplay disp = new CapDisplay(dispProps, src, this.d_capsEnabled);
        disp.setSelected(selected);
        disp.setVisible(visible);
        return disp;
    }

    @Override
    public void updateDisplay(IPyroGeomSrc obj, CapDisplay display) {
        this.updateSelection(obj, display);
        this.updateVisibility(obj, display);
        IDisplayableGeomSrc src = this.getSource(obj);
        display.setSource(src);
    }

    protected IDisplayableGeomSrc getSource(IPyroGeomSrc obj) {
        return obj instanceof Vent ? new VentProxy((Vent)obj, this) : obj;
    }

    @Override
    protected boolean isVisible(IPyroGeomSrc obj) {
        return obj.isEnabled() && obj.isVisible() && !this.isFiltered(obj);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.d_gridBoundaries = null;
    }

    @Override
    protected Set<? extends IPyroGeomSrc> getUpdateObjs(Events events, IEventRecord<IPyroGeomSrc> evts) {
        Set<IPyroGeomSrc> updateObjs = evts.getChangedObjs(EventChannel.EVT_GENERAL, PyroMod.EVT_APPEARANCE);
        IdentityHashSet additionalUpdateObjs = new IdentityHashSet();
        IEventRecord<Grid> gridEvts = events.getEvents(Grid.class, new Class[0]);
        Set<Grid> changedGrids = GeomDisplayMgr.getChangedDependedOn(events, Grid.class, new Object[0]);
        if (gridEvts.hasAddedObjs() || gridEvts.hasRemovedObjs() || !changedGrids.isEmpty()) {
            additionalUpdateObjs.addAll(this.getMediator().getSlcfList().flatten(PlanarSlice.class, this.getObjFilter().toTypedPredicate()));
            additionalUpdateObjs.addAll(this.getMediator().getSlcf3dList().flatten(VolumeSlice.class, this.getObjFilter().toTypedPredicate()));
            additionalUpdateObjs.addAll(this.getMediator().getObstructions().flatten(Vent.class, this.getObjFilter().toTypedPredicate()));
        }
        if (!additionalUpdateObjs.isEmpty()) {
            updateObjs = new IdentityHashSet<IPyroGeomSrc>(updateObjs);
            updateObjs.addAll(additionalUpdateObjs);
        }
        return updateObjs;
    }

    private static <T extends IPyroObject> Set<T> getChangedDependedOn(Events events, Class<T> depOnType, Object ... includeEvts) {
        IEventRecord<T> objEvents = events.getEvents(depOnType, new Class[0]);
        Set<T> changedObjs = includeEvts.length > 0 ? objEvents.getChangedObjs(includeEvts) : objEvents.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED);
        return changedObjs;
    }

    @Override
    public void processEvents(Events events, EventResult result) {
        IEventRecord<Grid> gridEvts = events.getEvents(Grid.class, new Class[0]);
        Set<Grid> changedGrids = gridEvts.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED);
        if (gridEvts.hasAddedObjs() || gridEvts.hasRemovedObjs() || !changedGrids.isEmpty()) {
            this.d_gridBoundaries = null;
        }
        super.processEvents(events, result);
    }

    @Override
    public void updateClipping(ClippingManager clipMgr) {
        if (!this.d_capsEnabled) {
            return;
        }
        theTimer timer = new theTimer();
        LinkedIdentityHashSet displays = new LinkedIdentityHashSet();
        for (CapDisplay disp : this.getDisplayMap().values()) {
            if (!disp.containsCaps) continue;
            displays.add(disp);
        }
        ConvexHull region = clipMgr.getClipRegion();
        IResult<IDisplayableGeomSrc> result = (obj, ctmt) -> {
            CapDisplay disp;
            if (ctmt == Containment.INTERSECTS && obj instanceof IPyroGeomSrc && (disp = (CapDisplay)this.getDisplay((IPyroGeomSrc)obj)) != null) {
                displays.add(disp);
            }
        };
        this.getMediator().getGeomLocator().find(region, result, true);
        System.out.printf("Updating clip caps for %d/%d displays...", displays.size(), this.getDisplayMap().size());
        System.out.flush();
        for (CapDisplay disp : displays) {
            disp.update();
        }
        System.out.printf("done (%g s)%n", timer.curr());
    }

    public GridMergeUtil.MergeResult getGridBoundaries() {
        if (this.d_gridBoundaries == null) {
            Collection grids = this.getMediator().getGridManager().flatten(new EnabledFilter());
            this.d_gridBoundaries = GridMergeUtil.mergeGrids(grids, Collections.EMPTY_LIST);
        }
        return this.d_gridBoundaries;
    }

    protected PyroDrawProps getDrawProps() {
        return this.d_drawProps;
    }

    private static class GeomSource
    implements IDisplayableGeomSrc {
        private DisplayGeom d_nextDisplay;

        public void update(DisplayGeom next) {
            this.d_nextDisplay = next;
        }

        @Override
        public AABox getBounds() {
            return null;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean visible) {
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            DisplayGeom geom = this.d_nextDisplay;
            this.d_nextDisplay = null;
            return geom;
        }
    }

    public static class CapDisplay
    implements IPyroDisplay {
        private IDisplayableGeomSrc d_src;
        private final GeomSource d_uncappedSrc;
        private final GeomSource d_cappedSrc;
        private final GeomDisplay d_uncappedDisp;
        private final GeomDisplay d_cappedDisp;
        public boolean containsCaps = false;

        public CapDisplay(INativeDisplayProps dispProps, IDisplayableGeomSrc source, boolean capsEnabled) {
            this.d_src = source;
            GeomSource geomSource = this.d_uncappedSrc = source instanceof VentProxy ? ((VentProxy)this.d_src).clone() : new GeomSource();
            this.d_cappedSrc = capsEnabled ? (source instanceof VentProxy ? ((VentProxy)this.d_src).clone() : new GeomSource()) : null;
            this.updateSources(dispProps);
            this.d_uncappedDisp = new GeomDisplay(dispProps, this.d_uncappedSrc);
            this.d_cappedDisp = capsEnabled ? new GeomDisplay(dispProps, this.d_cappedSrc) : null;
        }

        public void setSource(IDisplayableGeomSrc newSrc) {
            this.d_src = newSrc;
            this.update();
        }

        @Override
        public void getDisplayObjs(RenderTarget target, Collection<? super IDisplayable> displays) {
            switch (target) {
                case NORMAL: {
                    displays.add(this.d_uncappedDisp);
                    break;
                }
                case CLIP_CAPS: {
                    if (this.d_cappedDisp == null) break;
                    displays.add(this.d_cappedDisp);
                }
            }
        }

        private void apply(Consumer<GeomDisplay> disp) {
            disp.accept(this.d_uncappedDisp);
            if (this.d_cappedDisp != null) {
                disp.accept(this.d_cappedDisp);
            }
        }

        @Override
        public void setSelected(boolean selected) {
            this.apply(disp -> disp.setSelected(selected));
        }

        @Override
        public void setVisible(boolean visible) {
            this.apply(disp -> disp.setVisible(visible));
        }

        private void updateSources(INativeDisplayProps props) {
            PyroDrawProps pprops;
            ClippingManager cmgr;
            DisplayGeom uncapped = this.d_src.getDisplayGeom(props);
            DisplayGeom caps = DisplayGeom.EMPTY;
            if (this.d_cappedSrc != null && props instanceof PyroDrawProps && (cmgr = (pprops = (PyroDrawProps)props).getClippingManager()) != null && !cmgr.getClipRegion().acceptsAll()) {
                IElemSource<Point2d> defPrimUV = TexCoordGenerator.DEFAULT_OBJ;
                IPropsSrc psrc = null;
                boolean autoOpacity = false;
                psrc = cmgr.getClipProps();
                autoOpacity = true;
                caps = GeomUtil.generateClipCaps(pprops, uncapped, cmgr.getClipRegion(), psrc, autoOpacity, defPrimUV);
                boolean bl = this.containsCaps = caps.node.getNumPrims(7) != 0;
            }
            if (uncapped instanceof PyroDisplayGeom && (((PyroDisplayGeom)uncapped).options & 1) != 0) {
                uncapped = GeomUtil.convertToOutline(uncapped);
                caps = GeomUtil.convertToOutline(caps);
            }
            this.d_uncappedSrc.update(uncapped);
            if (this.d_cappedSrc != null) {
                this.d_cappedSrc.update(caps);
            }
        }

        @Override
        public void update() {
            this.updateSources(this.d_uncappedDisp.getDisplayProps());
            this.apply(disp -> disp.update());
        }
    }

    public static class VentProxy
    extends GeomSource
    implements IPickable,
    Cloneable {
        private final Vent d_vent;
        private final GeomDisplayMgr d_mgr;

        public VentProxy(Vent vent, GeomDisplayMgr mgr) {
            this.d_vent = vent;
            this.d_mgr = mgr;
        }

        public VentProxy clone() {
            return new VentProxy(this.d_vent, this.d_mgr);
        }

        @Override
        public AABox getBounds() {
            return this.d_vent.getBounds();
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps dispProps) {
            return this.d_vent.getDisplayGeom(dispProps);
        }

        @Override
        public boolean isVisible() {
            return this.d_vent.isVisible();
        }

        @Override
        public void setVisible(boolean visible) {
            this.d_vent.setVisible(visible);
        }

        private DisplayGeom getPickGeom() {
            return this.getDisplayGeom(this.d_mgr.getDrawProps());
        }

        @Override
        public void getAll(Consumer<Object> result, IIsectFilter filter) {
            IPickable.getAll(this.d_vent, result, filter);
        }

        @Override
        public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            IPickable.pickBox(this.d_vent, this::getPickGeom, result, filter, region);
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            IPickable.pickPoints(this.d_vent, this::getPickGeom, isects, filter, rayBegin, rayEnd, rayDirN, tester);
        }
    }
}

