/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Arrays;
import java.util.Collection;
import pyrosim.PyroMod;
import pyrosim.domain.Floor;
import pyrosim.domain.ModelImage;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.FloorDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.util.Events;

public class FloorDisplayManager
extends APyroDisplayMgr<Floor, FloorDisplay> {
    public FloorDisplayManager(PyroMod mod, ModelScene scene, ModelView mv, DisplayFilter filter) {
        super(mod, mv, FloorDisplayManager.newSceneMap(scene), Floor.class, filter);
    }

    @Override
    protected Collection<? extends Class<?>> getFilterTypes() {
        return Arrays.asList(ModelImage.class);
    }

    @Override
    public void addAll() {
        this.addDisplays(this.getMediator().getFloorManager().flatten());
    }

    @Override
    protected FloorDisplay createDisplay(Floor obj, boolean visible, boolean selected) {
        FloorDisplay disp = new FloorDisplay(obj);
        disp.setSelected(selected);
        disp.setVisible(visible);
        return disp;
    }

    @Override
    protected void filterChanged(DisplayFilter filter, Class type) {
        this.updateAll();
    }

    @Override
    protected boolean isVisible(Floor floor) {
        if (this.getMV() == null) {
            return false;
        }
        ModelImage bgImage = floor.getBgImage();
        boolean bgEnabled = bgImage != null && !this.isFiltered(bgImage);
        boolean isPersp = this.getScenes().apply(RenderTarget.NORMAL).get().getCamera() instanceof PerspectiveCamera;
        return bgEnabled && (isPersp || floor == this.getMV().getCurrentFloor());
    }

    @Override
    public void processEvents(Events events, EventResult result) {
        super.processEvents(events, result);
    }
}

