/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Collection;
import pyrosim.domain.Floor;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.ModelImageDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;

public class FloorDisplay
implements IPyroDisplay {
    private final Floor d_floor;
    private final ModelImageDisplay d_imageDisplay;

    public FloorDisplay(Floor f) {
        this.d_floor = f;
        this.d_imageDisplay = new ModelImageDisplay(this.d_floor.getBgImage());
        this.setVisible(true);
    }

    @Override
    public void getDisplayObjs(RenderTarget target, Collection<? super IDisplayable> displays) {
        switch (target) {
            case NORMAL: {
                displays.add(this.d_imageDisplay);
            }
        }
    }

    @Override
    public void setVisible(boolean vis) {
        this.d_imageDisplay.setVisible(vis);
    }

    @Override
    public void setSelected(boolean selected) {
        this.d_imageDisplay.setSelected(selected);
    }

    @Override
    public void update() {
        this.d_imageDisplay.setImage(this.d_floor.getBgImage());
    }

    public Floor getObject() {
        return this.d_floor;
    }

    public Object getSelectionObject() {
        return this.d_floor;
    }
}

