/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv;

import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.view.SectionBox;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.snappers.ISnapper;
import pyrosim.mv.snappers.OriginSnapper;
import pyrosim.mv.snappers.SnapToGrid;
import pyrosim.mv.tools.IPyroFunc;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.OrthoSnap;
import thunderheadeng.scene3d.picking.PolarSnap;
import thunderheadeng.util.Predicates;

public class PyroPickRoot
implements IPickRoot {
    private final PyroMod d_domain;
    private final ModelView d_mv;

    public PyroPickRoot(PyroMod domain, ModelView mv) {
        this.d_domain = domain;
        this.d_mv = mv;
    }

    @Override
    public IPickSession beginPicking() {
        return new Session();
    }

    private static Point3d getAngleSnapBasis(Tool currTool) {
        IPyroFunc pfunc;
        if (currTool instanceof IPyroTool) {
            return ((IPyroTool)currTool).getAngledSnapBasis();
        }
        if (currTool instanceof CursorTool && (pfunc = PyroPickRoot.getPyroFunc((CursorTool)currTool)) != null) {
            return pfunc.getAngledSnapBasis((CursorTool)currTool);
        }
        return null;
    }

    private static IPyroFunc getPyroFunc(CursorTool tool) {
        MultiFunc mf;
        IToolFunction<CursorTool> func = tool.getFunction();
        if (func instanceof IPyroFunc) {
            return (IPyroFunc)func;
        }
        if (func instanceof MultiFunc && (func = (mf = (MultiFunc)func).getActiveFunc(tool)) instanceof IPyroFunc) {
            return (IPyroFunc)func;
        }
        return null;
    }

    private static int getClassPreference(Object obj) {
        if (obj instanceof IHandle) {
            return 0;
        }
        if (obj instanceof HvacNode) {
            return 1;
        }
        if (obj instanceof FlowMeasurer) {
            return 2;
        }
        if (obj instanceof Vent) {
            return 3;
        }
        if (obj instanceof IHole) {
            return 4;
        }
        return 5;
    }

    private class Session
    implements IPickSession {
        private final boolean d_wireframe;
        private final Camera d_camera;

        private Session() {
            this.d_wireframe = PyroPickRoot.this.d_mv.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_WIREFRAME);
            this.d_camera = PyroPickRoot.this.d_mv.getMainView().getCamera();
        }

        @Override
        public boolean isVisible(IPickConfig config, Object o) {
            if (PyroPickRoot.this.d_mv.getManipMgr().isManipulating() && (o instanceof IHandle || PyroPickRoot.this.d_mv.getManipMgr().isManipulating(o))) {
                return false;
            }
            if (o instanceof IDisplayableGeomSrc) {
                boolean enabled = !(o instanceof IPyroObject) || ((IPyroObject)o).isEnabled();
                IDisplayableGeomSrc src = (IDisplayableGeomSrc)o;
                return src.isVisible() && enabled && !((PyroPickRoot)PyroPickRoot.this).d_mv.getDisplayManager().d_dispFilter.filter(o) || PyroPickRoot.this.d_domain.getSelectionModel().isSelected(src);
            }
            if (o instanceof ISnapConstraint) {
                return true;
            }
            return true;
        }

        @Override
        public IPickConfig[] getPickConfigs() {
            return new IPickConfig[]{new GeomConfig(), new InfiniteConfig()};
        }

        @Override
        public void find(IPickConfig config, ITest<AABox> test, IResult<IPickable> result) {
            IResult<IDisplayableGeomSrc> fresult;
            Predicate<Object> clipFilter = Predicates.alwaysFalse();
            for (IPyroDisplayMgr<?> mgr : PyroPickRoot.this.d_mv.getClipManager().getClippedDisplayMgrs()) {
                clipFilter = Predicates.or(clipFilter, mgr.getObjFilter().toArbitraryPredicate());
            }
            Predicate<Object> finiteSnapper = o -> o instanceof ISnapper && !this.isInfiniteSnapper((ISnapper)o);
            final Predicate<Object> clipFilter2 = clipFilter = Predicates.or(clipFilter, finiteSnapper);
            if (config instanceof GeomConfig) {
                final IResult<IPickable> baseResult = result;
                fresult = new IResult<IDisplayableGeomSrc>(){

                    @Override
                    public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                        if (!(obj instanceof IPickable) || !clipFilter2.test(obj)) {
                            return;
                        }
                        IPickable pobj = (IPickable)((Object)obj);
                        if (pobj instanceof Vent) {
                            for (IDisplayable display : PyroPickRoot.this.d_mv.getDisplayManager().getDisplayObjs((Vent)obj)) {
                                if (!(display instanceof GeomDisplay) || !(((GeomDisplay)display).getSource() instanceof IPickable)) continue;
                                pobj = (IPickable)((Object)((GeomDisplay)display).getSource());
                                break;
                            }
                        }
                        baseResult.mark(pobj, ctmt);
                    }
                };
            } else {
                this.findAdditionalSnaps(test, result);
                final IResult<IPickable> baseResult = result;
                fresult = new IResult<IDisplayableGeomSrc>(){

                    @Override
                    public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                        if (obj instanceof IPickable && !clipFilter2.test(obj)) {
                            baseResult.mark((IPickable)((Object)obj), ctmt);
                        }
                    }
                };
            }
            PyroPickRoot.this.d_domain.getGeomLocator().find(test, (IResult<? super IDisplayableGeomSrc>)fresult, true);
        }

        private boolean isInfiniteSnapper(ISnapper obj) {
            return obj instanceof SnapToGrid || obj instanceof OriginSnapper;
        }

        private void findAdditionalSnaps(ITest<AABox> test, IResult<IPickable> result) {
            Tool currTool;
            Point3d angleSnapBasis;
            boolean polarEnabled = this.d_camera instanceof OrthoCamera && !PyroPickRoot.this.d_mv.getManipMgr().isManipulating();
            boolean orthoEnabled = true;
            if ((polarEnabled || orthoEnabled) && (angleSnapBasis = PyroPickRoot.getAngleSnapBasis(currTool = PyroPickRoot.this.d_mv.getToolManager().getCurrentTool())) != null) {
                if (orthoEnabled) {
                    OrthoSnap os = new OrthoSnap(angleSnapBasis);
                    result.mark(os, Containment.INTERSECTS);
                }
                if (polarEnabled) {
                    Vector3d ref;
                    Vector3d axis;
                    if (this.d_camera instanceof OrthoCamera) {
                        OrthoCamera c = (OrthoCamera)this.d_camera;
                        axis = c.getViewVector();
                        axis.normalize();
                        axis.negate();
                        ref = c.getRightVector();
                        ref.normalize();
                    } else {
                        axis = GeomConstants.VEC3D_ZPOS;
                        ref = GeomConstants.VEC3D_XPOS;
                    }
                    PolarSnap ps = new PolarSnap(angleSnapBasis, axis, ref, Math.toRadians(15.0), new double[0]);
                    result.mark(ps, Containment.INTERSECTS);
                }
            }
        }

        @Override
        public void pickPoints(IPickable obj, IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            obj.pickPoints(isects, filter, rayBegin, rayEnd, rayDirN, tester);
        }

        @Override
        public void pickBox(IPickable obj, IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            obj.pickBox(result, filter, region);
        }

        @Override
        public boolean isWireframe(IPickConfig config, Object o) {
            if (o instanceof IHandle) {
                return false;
            }
            return this.d_wireframe || o instanceof IObstruction && ((IObstruction)o).getOptions(32) || o instanceof Vent && ((Vent)o).getOptions(1) || o instanceof SectionBox;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return PyroPickRoot.getClassPreference(o1) - PyroPickRoot.getClassPreference(o2);
        }

        @Override
        public boolean isOcclusionTarget(Object o) {
            if (o instanceof IGridSnapper) {
                return this.d_camera instanceof PerspectiveCamera;
            }
            return !(o instanceof ISnapper) && !(o instanceof ISnapConstraint);
        }

        @Override
        public boolean isOcclusionSource(Object o) {
            return (!PyroPickRoot.this.d_mv.getManipMgr().isManipulating() || PyroPickRoot.this.d_mv.getManipMgr().getCurrentManipObj() != o) && !PyroPickRoot.this.d_mv.getTransformMgr().isTransforming(o) && !(o instanceof IHandle) && this.isOccluder(o);
        }

        private boolean isOccluder(Object o) {
            return TVEntryPoints.ep(o).isOccluder(PyroPickRoot.this.d_domain, o);
        }

        private class InfiniteConfig
        implements IPickConfig {
            private InfiniteConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                return new ConvexHull(new Plane3d[0]);
            }
        }

        private class GeomConfig
        implements IPickConfig {
            private GeomConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                return PyroPickRoot.this.d_mv.getClipManager().getClipRegion();
            }
        }
    }
}

