/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.units.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class UnitLineSeg3D
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final double p1x;
    public final double p1y;
    public final double p1z;
    public final double p2x;
    public final double p2y;
    public final double p2z;
    public final Unit unit;

    public UnitLineSeg3D(double p1x, double p1y, double p1z, double p2x, double p2y, double p2z, Unit unit) {
        this.p1x = p1x;
        this.p1y = p1y;
        this.p1z = p1z;
        this.p2x = p2x;
        this.p2y = p2y;
        this.p2z = p2z;
        this.unit = unit;
    }

    public UnitLineSeg3D(Point3d p1, Point3d p2, Unit u) {
        this(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, u);
    }

    public UnitLineSeg3D(UnitPoint3D p1, UnitPoint3D p2) {
        this(p1.getPoint3dValue(p1.getUnit()), p2.getPoint3dValue(p1.getUnit()), p1.getUnit());
    }

    public UnitLineSeg3D(LineSeg3D seg, Unit u) {
        this(seg.getP1(), seg.getP2(), u);
    }

    public Point3d getP1(Unit u) {
        Converter converter = this.unit.getConverterTo(u);
        return new Point3d(converter.convert(this.p1x), converter.convert(this.p1y), converter.convert(this.p1z));
    }

    public Point3d getP2(Unit u) {
        Converter converter = this.unit.getConverterTo(u);
        return new Point3d(converter.convert(this.p2x), converter.convert(this.p2y), converter.convert(this.p2z));
    }

    public UnitPoint3D getP1() {
        return new UnitPoint3D(this.p1x, this.p1y, this.p1z, this.unit);
    }

    public UnitPoint3D getP2() {
        return new UnitPoint3D(this.p2x, this.p2y, this.p2z, this.unit);
    }

    public LineSeg3D getValue(Unit u) {
        Converter converter = this.unit.getConverterTo(u);
        return new LineSeg3D(new Point3d(converter.convert(this.p1x), converter.convert(this.p1y), converter.convert(this.p1z)), new Point3d(converter.convert(this.p2x), converter.convert(this.p2y), converter.convert(this.p2z)));
    }

    public UnitLineSeg3D transform(Matrix4d xform) {
        UnitPoint3D p1 = GeomUtil.xform(xform, this.getP1());
        UnitPoint3D p2 = GeomUtil.xform(xform, this.getP2());
        return new UnitLineSeg3D(p1, p2);
    }

    public Object clone() {
        try {
            UnitLineSeg3D clone = (UnitLineSeg3D)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitLineSeg3D)) {
            return false;
        }
        UnitLineSeg3D seg = (UnitLineSeg3D)obj;
        return this.getP1().equals(seg.getP1()) && this.getP2().equals(seg.getP2());
    }

    public int hashCode() {
        return -2089245877 + this.getP1().hashCode() + this.getP2().hashCode();
    }

    public UnitAABox getBounds() {
        AABox box = new AABox();
        this.getBounds(box, (Unit)SI.METER);
        return new UnitAABox(box, (Unit)SI.METER);
    }

    public void getBounds(AABox bb, Unit u) {
        bb.add(this.getP1(u), this.getP2(u));
    }
}

