/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.tools;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;

public class MathML_WordToJava {
    public static void main(String[] args) {
        String text = MathML_WordToJava.readClipboard();
        System.out.println(text);
        text = MathML_WordToJava.process(text);
        System.out.println(text);
        MathML_WordToJava.writeToClipboard(text);
    }

    private static String readClipboard() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable xfer = cb.getContents(null);
            if (xfer == null) {
                System.err.println("ERROR: No data on the clipboard.");
                return "";
            }
            Reader reader = DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(xfer);
            StringBuilder sbuilder = new StringBuilder();
            char[] buffer = new char[1024];
            int numRead = -1;
            while ((numRead = reader.read(buffer)) != -1) {
                sbuilder.append(buffer, 0, numRead);
            }
            return sbuilder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static void writeToClipboard(final String text) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        DataFlavor.getTextPlainUnicodeFlavor();
        Transferable contents = new Transferable(){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return text;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.match(DataFlavor.stringFlavor);
            }
        };
        cb.setContents(contents, null);
    }

    private static String process(String str) {
        str = str.replaceAll("\\:mml", "");
        str = str.replaceAll("mml\\:", "");
        str = str.replaceAll("\"", "\\\\\"");
        StringBuilder builder = new StringBuilder(str.length());
        for (int m = 0; m < str.length(); ++m) {
            char c = str.charAt(m);
            if (c > '\u00ff') {
                String newStr = String.format("\\u%04X", c);
                builder.append(newStr);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

