/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.text.ParseException;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiValueField;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.ValueRange;

public class guiUnitDoubleField
extends guiValueField<UnitDouble> {
    private static final long serialVersionUID = -1062088526787771326L;
    private Unit d_displayUnit;

    public guiUnitDoubleField(Unit u) {
        this(new UnitDouble(0.0, u));
    }

    public guiUnitDoubleField(double value, Unit unit) {
        this(new UnitDouble(value, unit));
    }

    public guiUnitDoubleField(UnitDouble value) {
        this(value, UnitDoubleVR.unbounded());
    }

    public guiUnitDoubleField(Unit u, DoubleVR range) {
        this(u, UnitDoubleVR.from(range, u));
    }

    public guiUnitDoubleField(Unit u, UnitDoubleVR range) {
        this(range.clampValue(new UnitDouble(0.0, u)), range);
    }

    public guiUnitDoubleField(double value, DoubleVR range, Unit unit) {
        this(new UnitDouble(value, unit), UnitDoubleVR.from(range, unit));
    }

    public guiUnitDoubleField(UnitDouble value, UnitDoubleVR range) {
        super(value, range);
        this.d_displayUnit = value.getUnit();
    }

    public Unit getDisplayUnit() {
        return this.d_displayUnit;
    }

    public void setDisplayUnit(Unit u) {
        if (u.equals((Object)this.d_displayUnit)) {
            return;
        }
        if (this.validateData(false, false)) {
            UnitDouble val = (UnitDouble)this.getValue();
            if (!val.isCompatible(u)) {
                val = val.reinterpret(u);
            }
            this.d_displayUnit = u;
            this.setValue(val);
        } else {
            this.d_displayUnit = u;
        }
    }

    private static String format(double val, Unit u) {
        return Global.format(val, u);
    }

    private String format(UnitDouble val, Unit u) {
        return guiUnitDoubleField.format(val.getValue(u), u);
    }

    @Override
    protected String format(UnitDouble value) {
        Unit u = this.d_displayUnit == null ? value.getUnit() : this.d_displayUnit;
        return this.format(value, u);
    }

    @Override
    public UnitDouble parse(String value) throws ParseException, IllegalArgumentException {
        UnitDouble udval = Global.parseUnitDouble(value, this.d_displayUnit);
        if (udval == null) {
            return this.getValueRange().clampValue(new UnitDouble(0.0, this.d_displayUnit));
        }
        return udval;
    }

    @Override
    protected ValueRange<UnitDouble> getUncheckedRange(UnitDouble value) {
        return UnitDoubleVR.unbounded();
    }
}

