/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;

public class RobotExec {
    private File d_file;
    private boolean d_skipMouseMovements;
    private Robot d_robot;
    private Scanner d_scanner;
    private final String versionNumber = "3.25";
    private final int LEFT_BUTTON = 1024;
    private final int MIDDLE_BUTTON = 2048;
    private final int RIGHT_BUTTON = 4096;
    private final int A = 30;
    private final int B = 48;
    private final int C = 46;
    private final int D = 32;
    private final int E = 18;
    private final int F = 33;
    private final int G = 34;
    private final int H = 35;
    private final int I = 23;
    private final int J = 36;
    private final int K = 37;
    private final int L = 38;
    private final int M = 50;
    private final int N = 49;
    private final int O = 24;
    private final int P = 25;
    private final int Q = 16;
    private final int R = 19;
    private final int S = 31;
    private final int T = 20;
    private final int U = 22;
    private final int V = 47;
    private final int W = 17;
    private final int X = 45;
    private final int Y = 21;
    private final int Z = 44;
    private final int CONTROL = 29;
    private final int L_SHIFT = 42;
    private final int R_SHIFT = 54;
    private final int CAPS_LOCK = 58;
    private final int TAB = 15;
    private final int ZERO = 11;
    private final int ONE = 2;
    private final int TWO = 3;
    private final int THREE = 4;
    private final int FOUR = 5;
    private final int FIVE = 6;
    private final int SIX = 7;
    private final int SEVEN = 8;
    private final int EIGHT = 9;
    private final int NINE = 10;
    private final int N_ZERO = 82;
    private final int N_ONE = 79;
    private final int N_TWO = 80;
    private final int N_THREE = 81;
    private final int N_FOUR = 75;
    private final int N_FIVE = 76;
    private final int N_SIX = 77;
    private final int N_SEVEN = 71;
    private final int N_EIGHT = 72;
    private final int N_NINE = 73;
    private final int ESCAPE = 1;
    private final int F1 = 59;
    private final int F2 = 60;
    private final int F3 = 61;
    private final int F4 = 62;
    private final int F5 = 63;
    private final int F6 = 64;
    private final int F7 = 65;
    private final int F8 = 66;
    private final int F9 = 67;
    private final int F10 = 68;
    private final int F11 = 87;
    private final int F12 = 88;
    private final int N_PERIOD = 83;
    private final int N_PLUS = 78;
    private final int N_MINUS = 74;
    private final int N_MULTIPLY = 55;
    private final int N_DIVIDE = 53;
    private final int NUM_LOCK = 69;
    private final int BACK_SPACE = 14;
    private final int EQUALS = 13;
    private final int MINUS = 12;
    private final int BACK_SLASH = 43;
    private final int CLOSE_BRACKET = 27;
    private final int OPEN_BRACKET = 26;
    private final int ENTER = 28;
    private final int APOSTROPHE = 40;
    private final int SEMICOLON = 39;
    private final int PERIOD = 52;
    private final int COMMA = 51;
    private final int FORWARD_APS = 41;
    private final int ALT = 56;
    private final int SPACE = 57;
    private final int SCROLL_LOCK = 70;

    public RobotExec(String fileName, boolean skipMouseMovements) throws FileNotFoundException {
        this(fileName, skipMouseMovements, null);
    }

    public RobotExec(URL fileName, boolean skipMouseMovements) throws FileNotFoundException {
        this(fileName, skipMouseMovements, null);
    }

    public RobotExec(URL fileName, boolean skipMouseMovements, guiDialog dlg) throws FileNotFoundException {
        try {
            this.d_file = new File(fileName.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.execute(fileName.getPath(), skipMouseMovements, dlg);
    }

    public RobotExec(String fileName, boolean skipMouseMovements, guiDialog dlg) throws FileNotFoundException {
        this.d_file = new File(fileName);
        this.execute(fileName, skipMouseMovements, dlg);
    }

    private void execute(String path, boolean skipMouseMovements, guiDialog dlg) throws FileNotFoundException {
        this.d_skipMouseMovements = skipMouseMovements;
        if (!this.d_file.exists()) {
            System.out.println("Invalid File Name: " + path);
            return;
        }
        try {
            this.d_robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.d_scanner = new Scanner(this.d_file);
        this.d_robot.setAutoWaitForIdle(true);
        if (dlg != null) {
            DlgLauncher t = new DlgLauncher(dlg);
            t.start();
            while (t.getState() == Thread.State.RUNNABLE) {
                Thread.yield();
            }
        }
        this.parseEvents();
    }

    private void parseEvents() {
        boolean isN = false;
        boolean button1IsPressed = false;
        boolean button2IsPressed = false;
        boolean button3IsPressed = false;
        while (!this.d_scanner.next().equals("3.25")) {
        }
        while (this.d_scanner.hasNext()) {
            this.d_scanner.nextInt();
            String event = this.d_scanner.next();
            String[] tokens = this.d_scanner.next().split(",");
            int delay = Integer.valueOf(tokens[0]);
            if (event.charAt(0) == 'K') {
                isN = tokens[2].equals("N");
                int keyCode = this.getCorrectKeyCode(Integer.parseInt(tokens[1]), isN);
                if (!this.d_skipMouseMovements) {
                    this.d_robot.delay(delay);
                }
                if (event.equals("KD")) {
                    this.d_robot.keyPress(keyCode);
                    continue;
                }
                this.d_robot.keyRelease(keyCode);
                continue;
            }
            int x = Integer.parseInt(tokens[1]);
            int y = Integer.parseInt(tokens[2]);
            if (event.equals("MO") && !this.d_skipMouseMovements || event.equals("MO") && (button1IsPressed || button2IsPressed || button3IsPressed)) {
                this.d_robot.delay(delay);
                this.d_robot.mouseMove(x, y);
                this.d_robot.waitForIdle();
                continue;
            }
            if (event.equals("MD")) {
                this.d_robot.mouseMove(x, y);
                this.d_robot.mousePress(2048);
                button2IsPressed = true;
                continue;
            }
            if (event.equals("MU")) {
                this.d_robot.delay(delay);
                this.d_robot.mouseMove(x, y);
                this.d_robot.mouseRelease(2048);
                button2IsPressed = false;
                continue;
            }
            if (event.equals("LD")) {
                this.d_robot.mouseMove(x, y);
                this.d_robot.mousePress(1024);
                button1IsPressed = true;
                continue;
            }
            if (event.equals("LU")) {
                this.d_robot.delay(delay);
                this.d_robot.mouseMove(x, y);
                this.d_robot.mouseRelease(1024);
                button1IsPressed = false;
                continue;
            }
            if (event.equals("RD")) {
                this.d_robot.mouseMove(x, y);
                this.d_robot.mousePress(4096);
                button3IsPressed = true;
                continue;
            }
            if (event.equals("RU")) {
                this.d_robot.delay(delay);
                this.d_robot.mouseMove(x, y);
                this.d_robot.mouseRelease(4096);
                button3IsPressed = false;
                continue;
            }
            if (!event.equals("WH")) continue;
            this.d_robot.delay(delay);
            this.d_robot.mouseMove(x, y);
            this.d_robot.mouseWheel(Integer.parseInt(tokens[3]));
        }
        this.releaseAll();
    }

    private void releaseAll() {
        this.d_robot.mouseRelease(1024);
        this.d_robot.mouseRelease(2048);
        this.d_robot.keyRelease(this.getCorrectKeyCode(30, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(48, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(46, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(32, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(18, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(33, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(34, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(35, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(23, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(36, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(37, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(38, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(50, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(49, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(24, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(25, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(16, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(19, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(31, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(20, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(22, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(47, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(17, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(45, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(21, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(44, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(29, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(42, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(54, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(58, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(15, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(11, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(2, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(3, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(4, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(5, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(6, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(7, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(8, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(9, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(10, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(82, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(79, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(80, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(81, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(75, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(76, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(77, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(71, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(72, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(73, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(82, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(79, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(80, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(81, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(75, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(76, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(77, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(71, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(72, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(73, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(1, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(59, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(60, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(61, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(62, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(63, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(64, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(65, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(66, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(67, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(68, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(87, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(88, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(83, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(83, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(78, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(74, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(55, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(55, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(53, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(53, false));
        this.d_robot.keyRelease(this.getCorrectKeyCode(69, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(14, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(13, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(12, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(43, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(27, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(26, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(28, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(40, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(39, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(52, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(51, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(41, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(56, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(57, true));
        this.d_robot.keyRelease(this.getCorrectKeyCode(70, true));
    }

    private int getCorrectKeyCode(int key, boolean isN) {
        switch (key) {
            case 30: {
                return 65;
            }
            case 48: {
                return 66;
            }
            case 46: {
                return 67;
            }
            case 32: {
                return 68;
            }
            case 18: {
                return 69;
            }
            case 33: {
                return 70;
            }
            case 34: {
                return 71;
            }
            case 35: {
                return 72;
            }
            case 23: {
                return 73;
            }
            case 36: {
                return 74;
            }
            case 37: {
                return 75;
            }
            case 38: {
                return 76;
            }
            case 50: {
                return 77;
            }
            case 49: {
                return 78;
            }
            case 24: {
                return 79;
            }
            case 25: {
                return 80;
            }
            case 16: {
                return 81;
            }
            case 19: {
                return 82;
            }
            case 31: {
                return 83;
            }
            case 20: {
                return 84;
            }
            case 22: {
                return 85;
            }
            case 47: {
                return 86;
            }
            case 17: {
                return 87;
            }
            case 45: {
                return 88;
            }
            case 21: {
                return 89;
            }
            case 44: {
                return 90;
            }
            case 82: {
                return isN ? 96 : 155;
            }
            case 79: {
                return isN ? 97 : 35;
            }
            case 80: {
                return isN ? 98 : 40;
            }
            case 81: {
                return isN ? 99 : 34;
            }
            case 75: {
                return isN ? 100 : 37;
            }
            case 76: {
                return 101;
            }
            case 77: {
                return isN ? 102 : 39;
            }
            case 71: {
                return isN ? 103 : 36;
            }
            case 72: {
                return isN ? 104 : 38;
            }
            case 73: {
                return isN ? 105 : 33;
            }
            case 53: {
                return isN ? 111 : 47;
            }
            case 83: {
                return isN ? 46 : 127;
            }
            case 55: {
                return isN ? 106 : 154;
            }
            case 11: {
                return 48;
            }
            case 2: {
                return 49;
            }
            case 3: {
                return 50;
            }
            case 4: {
                return 51;
            }
            case 5: {
                return 52;
            }
            case 6: {
                return 53;
            }
            case 7: {
                return 54;
            }
            case 8: {
                return 55;
            }
            case 9: {
                return 56;
            }
            case 10: {
                return 57;
            }
            case 42: {
                return 16;
            }
            case 54: {
                return 16;
            }
            case 29: {
                return 17;
            }
            case 58: {
                return 20;
            }
            case 15: {
                return 9;
            }
            case 56: {
                return 18;
            }
            case 57: {
                return 32;
            }
            case 1: {
                return 27;
            }
            case 59: {
                return 112;
            }
            case 60: {
                return 113;
            }
            case 61: {
                return 114;
            }
            case 62: {
                return 115;
            }
            case 63: {
                return 116;
            }
            case 64: {
                return 117;
            }
            case 65: {
                return 118;
            }
            case 66: {
                return 119;
            }
            case 67: {
                return 120;
            }
            case 68: {
                return 121;
            }
            case 87: {
                return 122;
            }
            case 88: {
                return 123;
            }
            case 78: {
                return 107;
            }
            case 74: {
                return 45;
            }
            case 69: {
                return 144;
            }
            case 14: {
                return 8;
            }
            case 13: {
                return 61;
            }
            case 12: {
                return 45;
            }
            case 43: {
                return 92;
            }
            case 27: {
                return 93;
            }
            case 26: {
                return 91;
            }
            case 28: {
                return 10;
            }
            case 39: {
                return 59;
            }
            case 52: {
                return 46;
            }
            case 51: {
                return 44;
            }
            case 70: {
                return 145;
            }
            case 40: {
                return 39;
            }
            case 41: {
                return 96;
            }
        }
        System.err.println("Case not found: " + key);
        return 0;
    }

    private class DlgLauncher
    extends Thread {
        private guiDialog d_dlg;

        public DlgLauncher(guiDialog dlg) {
            this.d_dlg = dlg;
        }

        @Override
        public void run() {
            this.d_dlg.doModal();
        }
    }
}

