/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v31.domain.geom;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public abstract class AAlignedFDSObject
extends AbstractFDSObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    protected UnitPoint3D d_minPoint;
    protected UnitPoint3D d_maxPoint;
    public static final byte MIN_X = 0;
    public static final byte MAX_X = 1;
    public static final byte MIN_Y = 2;
    public static final byte MAX_Y = 3;
    public static final byte MIN_Z = 4;
    public static final byte MAX_Z = 5;
    public static final int NUM_FACES = 6;
    private static final String[] FACE_NAMES = new String[]{Intl.intl("Min X"), Intl.intl("Max X"), Intl.intl("Min Y"), Intl.intl("Max Y"), Intl.intl("Min Z"), Intl.intl("Max Z")};
    private static final byte X = 0;
    private static final byte Y = 1;
    private static final byte Z = 2;
    private static final int NUM_ROT_AXES = 3;
    private static final byte[][] FACE_INDEX_ROT_LU;
    private static final Vector3d[] s_faceDirs;

    protected static int getIndexForFaceDir(Vector3d dir) {
        if (dir.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-6)) {
            return 0;
        }
        if (dir.epsilonEquals(GeomConstants.VEC3D_XPOS, 1.0E-6)) {
            return 1;
        }
        if (dir.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-6)) {
            return 2;
        }
        if (dir.epsilonEquals(GeomConstants.VEC3D_YPOS, 1.0E-6)) {
            return 3;
        }
        if (dir.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-6)) {
            return 4;
        }
        if (dir.epsilonEquals(GeomConstants.VEC3D_ZPOS, 1.0E-6)) {
            return 5;
        }
        return -1;
    }

    public String toString() {
        String str = null;
        if (this.d_maxPoint == null || this.d_minPoint == null) {
            str = this.getClass().getName();
        } else {
            BaseUnit unit = SI.METER;
            str = this.getClass().getName() + ": (" + Global.format(this.d_minPoint.x((Unit)unit)) + ", " + Global.format(this.d_minPoint.y((Unit)unit)) + ", " + Global.format(this.d_minPoint.z((Unit)unit)) + ") to (" + Global.format(this.d_maxPoint.x((Unit)unit)) + ", " + Global.format(this.d_maxPoint.y((Unit)unit)) + ", " + Global.format(this.d_maxPoint.z((Unit)unit)) + ")";
        }
        String name = this.d_name;
        if (name != null && !name.equals("")) {
            str = str + " [" + name + "]";
        }
        return str;
    }

    protected AABoxGeom convertGeom() {
        return new AABoxGeom(this.d_minPoint.getPoint3dValue(Geometry.LU), this.d_maxPoint.getPoint3dValue(Geometry.LU), 0);
    }

    static {
        byte[][] rotlu = FACE_INDEX_ROT_LU = new byte[3][6];
        rotlu[0][0] = 0;
        rotlu[0][1] = 1;
        rotlu[0][2] = 4;
        rotlu[0][3] = 5;
        rotlu[0][4] = 3;
        rotlu[0][5] = 2;
        rotlu[1][0] = 5;
        rotlu[1][1] = 4;
        rotlu[1][2] = 2;
        rotlu[1][3] = 3;
        rotlu[1][4] = 0;
        rotlu[1][5] = 1;
        rotlu[2][0] = 2;
        rotlu[2][1] = 3;
        rotlu[2][2] = 1;
        rotlu[2][3] = 0;
        rotlu[2][4] = 4;
        rotlu[2][5] = 5;
        s_faceDirs = new Vector3d[6];
        AAlignedFDSObject.s_faceDirs[0] = GeomConstants.VEC3D_XNEG;
        AAlignedFDSObject.s_faceDirs[1] = GeomConstants.VEC3D_XPOS;
        AAlignedFDSObject.s_faceDirs[2] = GeomConstants.VEC3D_YNEG;
        AAlignedFDSObject.s_faceDirs[3] = GeomConstants.VEC3D_YPOS;
        AAlignedFDSObject.s_faceDirs[4] = GeomConstants.VEC3D_ZNEG;
        AAlignedFDSObject.s_faceDirs[5] = GeomConstants.VEC3D_ZPOS;
    }

    public static class AAlignedFDSObjectFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        protected AAlignedFDSObject d_block;
        protected byte d_index;
    }
}

