/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.particle.ConstColoring;
import pyrosim.legacy_2012_1.domain.particle.DropletColoring;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.FuelPyrolysis;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IColoring;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.Pyrolysis;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.ThermalProps;
import pyrosim.legacy_2012_1.domain.particle.TracerPartDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseWarning;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.common.ParticleQuantityMap;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ParticleParser
extends AFDS5Parser {
    private final PinConnParser d_pinConns;

    public ParticleParser(FDS5ParsingInfo parsingInfo, PinConnParser pinConns) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PART");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
        unsupportedFields.add("HORIZONTAL_VELOCITY");
        unsupportedFields.add("VERTICAL_VELOCITY");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = (String)rec.get("ID", false);
        if (!this.checkName(rec, id)) {
            return false;
        }
        IParticleDesc desc = ParticleParser.parsePartDesc(this.getParsingInfo(), rec);
        Particle part = new Particle(id, desc);
        part.setFYI(rec.getString("FYI", false));
        part.setCustomFDSProps(this.getCustomVals(rec));
        int exists = this.existsStatus(rec, part, Particle.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        this.getContainer().getPartList().add(part);
        this.flagObjectAdded(part);
        ParticleParser.markSingleInputForRetrieval(rec, part, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    public static IParticleDesc parsePartDesc(FDSParsingInfo pi, FDSParseRecord rec) throws FDSRecordFormatException {
        TracerPartDesc tracer = ParticleParser.parseTracer(pi, rec);
        if (tracer != null) {
            return tracer;
        }
        WaterPartDesc water = ParticleParser.parseWater(pi, rec);
        if (water != null) {
            return water;
        }
        FuelPartDesc fuel = ParticleParser.parseFuel(pi, rec);
        if (fuel != null) {
            return fuel;
        }
        return ParticleParser.parseGeneric(pi, rec);
    }

    private static TracerPartDesc parseTracer(FDSParsingInfo pi, FDSParseRecord rec) throws FDSRecordFormatException {
        if (!rec.getBoolean("MASSLESS", true).booleanValue()) {
            return null;
        }
        Color color = ParticleParser.parseColor(pi, rec, "RGB", "COLOR", null, true);
        Output output = ParticleParser.parseOutput(rec, 1);
        return new TracerPartDesc(color, output);
    }

    private static WaterPartDesc parseWater(FDSParsingInfo pi, FDSParseRecord rec) throws FDSRecordFormatException {
        if (!rec.getBoolean("WATER", true).booleanValue()) {
            return null;
        }
        return new WaterPartDesc(ParticleParser.parseThermalPropsWater(rec), ParticleParser.parsePyrolysisWater(rec), ParticleParser.parseSizeDist(pi, rec), ParticleParser.parseOutput(rec, 10), ParticleParser.parseColoring(pi, rec), rec.getInteger("DROPLETS_PER_SECOND", true));
    }

    private static FuelPartDesc parseFuel(FDSParsingInfo pi, FDSParseRecord rec) throws FDSRecordFormatException {
        if (!rec.getBoolean("FUEL", true).booleanValue()) {
            return null;
        }
        return new FuelPartDesc(ParticleParser.parseThermalProps(rec), ParticleParser.parseFuelPyrolysis(rec), ParticleParser.parseSizeDist(pi, rec), ParticleParser.parseOutput(rec, 10), ParticleParser.parseColoring(pi, rec), (int)rec.getInteger("DROPLETS_PER_SECOND", true));
    }

    private static GenericPartDesc parseGeneric(FDSParsingInfo pi, FDSParseRecord rec) throws FDSRecordFormatException {
        return new GenericPartDesc(ParticleParser.parseThermalProps(rec), ParticleParser.parseGenericPyrolysis(pi, rec), ParticleParser.parseSizeDist(pi, rec), ParticleParser.parseOutput(rec, 10), ParticleParser.parseColoring(pi, rec), rec.getInteger("DROPLETS_PER_SECOND", true));
    }

    private static ThermalProps parseThermalProps(FDSParseRecord rec) {
        return new ThermalProps(rec.getUnitDouble("DENSITY", true), rec.getUnitDouble("SPECIFIC_HEAT", true), rec.getUnitDouble("INITIAL_TEMPERATURE", true));
    }

    private static ThermalProps parseThermalPropsWater(FDSParseRecord rec) {
        UnitDouble specificHeat = rec.getUnitDouble("SPECIFIC_HEAT");
        if (specificHeat == null) {
            specificHeat = new UnitDouble(4.184, SI.KILO((Unit)SI.JOULE).divide(SI.KILOGRAM.multiply((Unit)SI.KELVIN)));
        }
        return new ThermalProps(rec.getUnitDouble("DENSITY", true), specificHeat, rec.getUnitDouble("INITIAL_TEMPERATURE", true));
    }

    private static Pyrolysis parseGenericPyrolysis(FDSParsingInfo pi, FDSParseRecord rec) {
        UnitDouble meltTemp = rec.getUnitDouble("MELTING_TEMPERATURE", true);
        boolean evapOn = rec.getBoolean("EVAPORATE", true);
        if (evapOn) {
            String specId = rec.getString("SPEC_ID", false);
            ExSpec vapSpec = null;
            if (specId != null && (vapSpec = pi.findObject(ExSpec.class, specId)) == null) {
                pi.addWarning(rec, String.format(Intl.intl("Could not find SPEC with ID \"%s.\""), specId), Intl.intl("Ignoring vaporization species."));
            }
            return Pyrolysis.evapOn(meltTemp, rec.getUnitDouble("VAPORIZATION_TEMPERATURE", true), rec.getUnitDouble("HEAT_OF_VAPORIZATION", true), vapSpec);
        }
        return Pyrolysis.evapOff(meltTemp);
    }

    private static Pyrolysis parsePyrolysisWater(FDSParseRecord rec) {
        UnitDouble meltingTemperature = rec.getUnitDouble("MELTING_TEMPERATURE");
        UnitDouble heatOfVaporization = rec.getUnitDouble("HEAT_OF_VAPORIZATION");
        UnitDouble vaporizationTemperature = rec.getUnitDouble("VAPORIZATION_TEMPERATURE");
        if (meltingTemperature == null) {
            meltingTemperature = new UnitDouble(0.0, SI.CELSIUS);
        }
        if (heatOfVaporization == null) {
            heatOfVaporization = new UnitDouble(2259.0, SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM));
        }
        if (vaporizationTemperature == null) {
            vaporizationTemperature = new UnitDouble(100.0, SI.CELSIUS);
        }
        return Pyrolysis.evapOn(meltingTemperature, vaporizationTemperature, heatOfVaporization, null);
    }

    private static Pyrolysis parsePyrolysisFuel(FDSParseRecord rec) {
        return Pyrolysis.evapOn(rec.getUnitDouble("MELTING_TEMPERATURE", false), rec.getUnitDouble("VAPORIZATION_TEMPERATURE", false), rec.getUnitDouble("HEAT_OF_VAPORIZATION", false), null);
    }

    private static FuelPyrolysis parseFuelPyrolysis(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitDouble heatOfCombust = (UnitDouble)rec.get("HEAT_OF_COMBUSTION", true);
        if (heatOfCombust == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Fuel particles must specify a heat of combustion."));
        }
        Pyrolysis py = ParticleParser.parsePyrolysisFuel(rec);
        return new FuelPyrolysis(py.d_meltingTemp, py.d_vapTemp, py.d_heatOfVap, heatOfCombust);
    }

    private static IColoring parseColoring(FDSParsingInfo pi, FDSParseRecord rec) {
        if (rec.contains("QUANTITIES")) {
            List quantities = rec.getList("QUANTITIES", false);
            ArrayList<Integer> propVals = new ArrayList<Integer>(quantities.size());
            for (String quantity : quantities) {
                Integer val = ParticleQuantityMap.getPyroVal(quantity);
                if (val == null) {
                    pi.addWarning(rec, String.format(Intl.intl("Unknown particle coloring quantity, %s."), quantity), Intl.intl("Ignoring coloring quantity."));
                    continue;
                }
                propVals.add(val);
            }
            return new DropletColoring(propVals);
        }
        Color c = ParticleParser.parseColor(pi, rec, "RGB", "COLOR", null, false);
        if (c != null) {
            return new ConstColoring(c);
        }
        return null;
    }

    private static SizeDistribution parseSizeDist(FDSParsingInfo pi, FDSParseRecord rec) {
        SizeDistribution.Type type;
        UnitDouble diam = (UnitDouble)rec.get("DIAMETER", true);
        boolean mono = (Boolean)rec.get("MONODISPERSE", true);
        if (mono) {
            type = new SizeDistribution.Constant();
        } else {
            UnitDouble minDiam = (UnitDouble)rec.get("MINIMUM_DIAMETER", true);
            UnitDouble maxDiam = (UnitDouble)rec.get("MAXIMUM_DIAMETER", true);
            if (minDiam.getValue((Unit)SI.METER) > maxDiam.getValue((Unit)SI.METER)) {
                pi.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("The maximum diameter is less than the minimum diameter (min=%1$s, max=%2$s)."), minDiam.toString(), maxDiam.toString()), Intl.intl("Switching minimum and maximum diameters.")));
                UnitDouble temp = minDiam;
                minDiam = maxDiam;
                maxDiam = temp;
            }
            double gammaD = (Double)rec.get("GAMMA_D", true);
            Double sigma = rec.getDouble("SIGMA_D", true);
            type = new SizeDistribution.RosinRammler(gammaD, minDiam, maxDiam, sigma);
        }
        return new SizeDistribution(diam, type);
    }

    private static Output parseOutput(FDSParseRecord rec, int defSampleFreq) {
        int sampleFreq = rec.getInteger("SAMPLING_FACTOR", true);
        if (sampleFreq == -1) {
            sampleFreq = defSampleFreq;
        }
        return new Output(rec.getUnitDouble("AGE", true), rec.getUnitDouble("DT_INSERT", true), sampleFreq);
    }
}

