/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class Multiplier {
    private final String d_id;
    private final UnitPoint3D d_offset;
    private final UnitDouble[] d_sx;
    private final UnitDouble[] d_sy;
    private final UnitDouble[] d_sz;
    private final int[] d_i;
    private final int[] d_j;
    private final int[] d_k;
    private final int[] d_n;

    public Multiplier(String id, UnitPoint3D offset, UnitDouble[] sx, UnitDouble[] sy, UnitDouble[] sz, UnitDouble sx1, UnitDouble sy1, UnitDouble sz1, int[] i, int[] j, int[] k, int[] n) {
        this.d_id = id;
        this.d_offset = offset;
        this.d_sx = sx;
        this.d_sy = sy;
        this.d_sz = sz;
        Multiplier.applySingleScalar(sx1, this.d_sx);
        Multiplier.applySingleScalar(sy1, this.d_sy);
        Multiplier.applySingleScalar(sz1, this.d_sz);
        if (n[0] != 0 || n[1] != 0) {
            this.d_n = n;
            this.d_k = null;
            this.d_j = null;
            this.d_i = null;
        } else {
            this.d_i = i;
            this.d_j = j;
            this.d_k = k;
            this.d_n = null;
        }
    }

    private static void applySingleScalar(UnitDouble scalar, UnitDouble[] s) {
        if (scalar.getValueNoUnit() != 0.0) {
            s[0] = s[1] = scalar;
        }
    }

    public String getID() {
        return this.d_id;
    }

    public boolean isSequential() {
        return this.d_n != null;
    }

    public int getNumCopies() {
        if (this.isSequential()) {
            return Multiplier.count(this.d_n);
        }
        return Multiplier.count(this.d_i) * Multiplier.count(this.d_j) * Multiplier.count(this.d_k);
    }

    private static int count(int[] v) {
        return Math.max(0, v[1] - v[0] + 1);
    }

    private double[] getScale(UnitDouble[] scale, Unit unit) {
        return new double[]{scale[0].getValue(unit), scale[1].getValue(unit)};
    }

    public <T extends IPyroGeomSrc> Pair<String, List<T>> applyTo(T obj) {
        IGeom geom = obj.getGeom();
        String name = obj instanceof INamed ? ((INamed)((Object)obj)).getName() : "";
        int numCopies = this.getNumCopies();
        if (numCopies == 0) {
            return new Pair<String, List<T>>("", Collections.EMPTY_LIST);
        }
        Unit unit = Geometry.LU;
        AABox bounds = geom.getBoundingBox(new AABox());
        Point3d offset = this.d_offset.getPoint3dValue(unit);
        double[] sx = this.getScale(this.d_sx, unit);
        double[] sy = this.getScale(this.d_sy, unit);
        double[] sz = this.getScale(this.d_sz, unit);
        ArrayList objs = new ArrayList(numCopies);
        if (this.isSequential()) {
            for (int n = this.d_n[0]; n <= this.d_n[1]; ++n) {
                double dn = n;
                Matrix4d xform = Multiplier.createXform(bounds, offset, sx, sy, sz, dn, dn, dn);
                Multiplier.append(objs, numCopies, obj, xform, String.format("[%d]", n));
            }
        } else {
            for (int k = this.d_k[0]; k <= this.d_k[1]; ++k) {
                for (int j = this.d_j[0]; j <= this.d_j[1]; ++j) {
                    for (int i = this.d_i[0]; i <= this.d_i[1]; ++i) {
                        Matrix4d xform = Multiplier.createXform(bounds, offset, sx, sy, sz, i, j, k);
                        Multiplier.append(objs, numCopies, obj, xform, String.format("[%d,%d,%d]", i, j, k));
                    }
                }
            }
        }
        return new Pair<String, List<T>>(name, objs);
    }

    private static Matrix4d createXform(AABox bounds, Point3d offset, double[] sx, double[] sy, double[] sz, double i, double j, double k) {
        Point3d bmin = bounds.getMin();
        Matrix4d xform = Util.translateMat(offset.x + bmin.x + sx[0] * i, offset.y + bmin.y + sy[0] * j, offset.z + bmin.z + sz[0] * k);
        xform.mul(Util.scaleMat(1.0 + i * (sx[1] - sx[0]) / bounds.getWidth(), 1.0 + j * (sy[1] - sy[0]) / bounds.getDepth(), 1.0 + k * (sz[1] - sz[0]) / bounds.getHeight()));
        xform.mul(Util.translateMat(-bmin.x, -bmin.y, -bmin.z));
        return xform;
    }

    private static <T extends IPyroGeomSrc> void append(List<T> objs, int totalNumCopies, T baseObj, Matrix4d xform, String postFix) {
        IPyroGeomSrc clone = (IPyroGeomSrc)baseObj.clone();
        clone.setGeom(clone.getGeom().transform(xform, IGeom.XformOp.RETAINED), true);
        if (totalNumCopies > 1 && clone instanceof INamed) {
            INamed namedObj = (INamed)((Object)clone);
            namedObj.setName(namedObj.getName() + postFix);
        }
        objs.add(clone);
    }
}

