/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.FDSVersion;
import pyrosim.Version;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class GE1File {
    public static boolean writeFile(String filename, PyroMod mod) throws IOException {
        return GE1File.writeFile(filename, mod, Version.FDS_DESIGN);
    }

    public static boolean writeFile(String filename, PyroMod mod, FDSVersion smvVersion) throws IOException {
        System.out.println("Writing GE1 File...");
        theTimer timer = new theTimer();
        ArrayList<PolyInfo> polys = new ArrayList<PolyInfo>();
        ArrayList<Appearance> appearances = new ArrayList<Appearance>();
        GE1File.getPolys(mod, appearances, polys);
        System.out.println(String.format("   %d polys", polys.size()));
        System.out.println(String.format("   %d appearances", appearances.size()));
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        writer.println("[APPEARANCE]");
        writer.println(appearances.size());
        GE1File.writeAppearances(writer, appearances, smvVersion);
        writer.println("[FACES]");
        writer.println(polys.size());
        GE1File.writePrims(writer, polys);
        writer.close();
        System.out.println("GE1 Written in " + timer.curr() * 1000.0 + " ms");
        return true;
    }

    private static void getPolys(PyroMod mod, List<Appearance> appearances, List<PolyInfo> polyInfos) {
        LinkedHashMap<Appearance, Integer> appearanceMap = new LinkedHashMap<Appearance, Integer>();
        for (IPyroGeomSrc obj : mod.getObstructions().flatten()) {
            DisplayGeom dispGeom = obj.getDisplayGeom(null);
            IPropsSrc props = dispGeom.props;
            List prims = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.explode(dispGeom.geom, IPrimitive.class);
            for (int m = 0; m < prims.size(); ++m) {
                IPrimitive prim = (IPrimitive)prims.get(m);
                if (!(prim instanceof IFace)) continue;
                IFace face = (IFace)prim;
                IPrimProps fprops = props.get(m);
                int appIx = GE1File.getAppearance(fprops, appearanceMap);
                List<IPolygon> polys = GeomUtil.toPolys(face, 0.1, false);
                for (IPolygon poly : polys) {
                    if (poly.getNumLoops() > 1 || poly.getNumPoints(0) > 4) {
                        Mesh mesh = poly.triangulate(0.1);
                        int n = 0;
                        while (n < mesh.indices.length) {
                            Point3d p1 = mesh.vertices[mesh.indices[n++]];
                            Point3d p2 = mesh.vertices[mesh.indices[n++]];
                            Point3d p3 = mesh.vertices[mesh.indices[n++]];
                            polyInfos.add(new PolyInfo(new Triangle(p1, p2, p3), appIx));
                        }
                        continue;
                    }
                    polyInfos.add(new PolyInfo(poly, appIx));
                }
            }
        }
        appearances.addAll(appearanceMap.keySet());
    }

    private static void writeAppearances(PrintWriter writer, Collection<Appearance> appearances, FDSVersion smvVersion) {
        Unit lu = SIUS.getInstance().getLengthUnit();
        float[] ccomps = new float[3];
        Iterator<Appearance> appIt = appearances.iterator();
        for (int i = 0; i < appearances.size(); ++i) {
            Appearance app = appIt.next();
            Surface surf = app.d_surf;
            Color c = app.d_color;
            writer.println(app.toString());
            TextureInfo texinfo = null;
            if (surf != null) {
                texinfo = surf.getTextureInfo();
            }
            double width = 0.0;
            double height = 0.0;
            String texname = "";
            if (texinfo != null) {
                width = texinfo.getWidth().getValue(lu);
                height = texinfo.getHeight().getValue(lu);
                texname = texinfo.getTexID();
            }
            writer.print(i);
            writer.print(' ');
            if (smvVersion.major < 6) {
                c.getColorComponents(ccomps);
                writer.printf("%f %f %f", Float.valueOf(ccomps[0]), Float.valueOf(ccomps[1]), Float.valueOf(ccomps[2]));
            } else {
                writer.printf("%d %d %d", c.getRed(), c.getGreen(), c.getBlue());
            }
            writer.printf(" %f, %f", width, height);
            if (c.getAlpha() < 255) {
                writer.print(", ");
                writer.print((float)c.getAlpha() / 255.0f);
            }
            writer.println();
            writer.println(texname);
        }
    }

    private static void writePrims(PrintWriter writer, List<PolyInfo> polys) {
        for (int m = 0; m < polys.size(); ++m) {
            PolyInfo pi = polys.get(m);
            int numPoints = pi.poly.getNumPoints(0);
            if (numPoints == 3) {
                GE1File.writeQuad(writer, pi.appearanceIx, pi.poly.getPoint(0, 0), pi.poly.getPoint(0, 1), pi.poly.getPoint(0, 2), pi.poly.getPoint(0, 2));
                continue;
            }
            if (numPoints != 4) continue;
            GE1File.writeQuad(writer, pi.appearanceIx, pi.poly.getPoint(0, 0), pi.poly.getPoint(0, 1), pi.poly.getPoint(0, 2), pi.poly.getPoint(0, 3));
        }
    }

    private static void writeQuad(PrintWriter writer, int appearance, Point3d p1, Point3d p2, Point3d p3, Point3d p4) {
        GE1File.writePoint(writer, p1);
        GE1File.writePoint(writer, p2);
        GE1File.writePoint(writer, p3);
        GE1File.writePoint(writer, p4);
        writer.println(appearance);
    }

    private static void writePoint(PrintWriter writer, Point3d p) {
        writer.print((float)p.x);
        writer.print(" ");
        writer.print((float)p.y);
        writer.print(" ");
        writer.print((float)p.z);
        writer.print(" ");
    }

    private static int getAppearance(IPrimProps props, Map<Appearance, Integer> appearanceMap) {
        Surface surface = (Surface)props.getMaterial();
        Appearance app = new Appearance(surface, GE1File.getColor(props));
        Integer ix = appearanceMap.get(app);
        if (ix == null) {
            ix = appearanceMap.size();
            appearanceMap.put(app, ix);
        }
        return ix;
    }

    private static Color getColor(IPrimProps props) {
        if (props.getColor() != null) {
            return props.getColor();
        }
        if (props.getMaterial() != null) {
            return (Color)props.getMaterial().getDiffuse().v1;
        }
        return null;
    }

    private static class Appearance {
        public final Surface d_surf;
        public final Color d_color;

        public Appearance(Surface surf, Color color) {
            this.d_surf = surf;
            this.d_color = color;
        }

        public int hashCode() {
            return 35912251 + theUtil.hashCode(this.d_surf) + theUtil.hashCode(this.d_color);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Appearance)) {
                return false;
            }
            Appearance ao = (Appearance)o;
            return theUtil.equal(ao.d_color, this.d_color) && theUtil.equal(ao.d_surf, this.d_surf);
        }

        public String toString() {
            String surfStr = this.d_surf != null ? this.d_surf.getName() : "";
            String colorStr = this.d_color != null ? String.format("r=%d,g=%d,b=%d,a=%d", this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), this.d_color.getAlpha()) : "";
            return String.format("Appearance[%s,%s]", surfStr, colorStr);
        }
    }

    private static class PolyInfo {
        public final IPolygon poly;
        public final int appearanceIx;

        public PolyInfo(IPolygon poly, int appearanceIx) {
            this.poly = poly;
            this.appearanceIx = appearanceIx;
        }
    }
}

