/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.Serialized;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.Hole;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;

public class BimImporter {
    private static final int PT_GROUPS = 0;
    private static final int PT_MATERIALS = 1;
    private static final int PT_WALLS = 2;
    private static final int PT_SLABS = 3;
    private static final int PT_FURNISHINGS = 4;
    private static final int PT_HOLES = 5;

    public static void open(Serialized ser, String filename) throws IOException {
        Surface defSurf = (Surface)ser.surfmgr.get(PredefSurf.INERT.name());
        int parseType = -1;
        IdentityHashMap<ModelComposite, Integer> groupParentMap = new IdentityHashMap<ModelComposite, Integer>();
        ArrayList<ModelComposite> groups = new ArrayList<ModelComposite>();
        ArrayList<Surface> surfaces = new ArrayList<Surface>();
        ArrayList<FDSObject> walls = new ArrayList<FDSObject>();
        ArrayList<FDSObject> holes = new ArrayList<FDSObject>();
        ArrayList<FDSObject> furnishings = new ArrayList<FDSObject>();
        ArrayList<FDSObject> slabs = new ArrayList<FDSObject>();
        int lineno = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            Object object = null;
            try {
                String string;
                while ((string = reader.readLine()) != null) {
                    ++lineno;
                    String string2 = string.trim();
                    if (string2.equals("[groups]")) {
                        parseType = 0;
                        continue;
                    }
                    if (string2.equals("[materials]")) {
                        parseType = 1;
                        continue;
                    }
                    if (string2.equals("[walls]")) {
                        parseType = 2;
                        continue;
                    }
                    if (string2.equals("[slabs]")) {
                        parseType = 3;
                        continue;
                    }
                    if (string2.equals("[furnishings]")) {
                        parseType = 4;
                        continue;
                    }
                    if (string2.equals("[holes]")) {
                        parseType = 5;
                        continue;
                    }
                    if (string2.length() <= 0) continue;
                    switch (parseType) {
                        case 0: {
                            ModelComposite group = BimImporter.parseGroup(string2, groupParentMap);
                            if (group == null) break;
                            groups.add(group);
                            break;
                        }
                        case 1: {
                            Surface surf = BimImporter.parseMaterial(string2);
                            if (surf == null) break;
                            surfaces.add(surf);
                            break;
                        }
                        case 2: {
                            FDSObject obj = BimImporter.parseSolid(string2, groups, defSurf, surfaces);
                            if (obj == null) break;
                            walls.add(obj);
                            break;
                        }
                        case 3: {
                            FDSObject obj = BimImporter.parseSolid(string2, groups, defSurf, surfaces);
                            if (obj == null) break;
                            slabs.add(obj);
                            break;
                        }
                        case 4: {
                            FDSObject obj = BimImporter.parseSolid(string2, groups, defSurf, surfaces);
                            if (obj == null) break;
                            furnishings.add(obj);
                            break;
                        }
                        case 5: {
                            FDSObject obj = BimImporter.parseHole(string2, groups);
                            if (obj == null) break;
                            holes.add(obj);
                            break;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IOException(String.format(Intl.intl("Error on line %d: %s"), lineno, e.getMessage()));
        }
        ArrayList rootGroups = new ArrayList();
        for (Map.Entry entry : groupParentMap.entrySet()) {
            if ((Integer)entry.getValue() == -1) {
                rootGroups.add(entry.getKey());
                continue;
            }
            ((ModelComposite)groups.get((Integer)entry.getValue())).add((IPyroObject)entry.getKey());
        }
        ser.surfmgr.addAll(surfaces);
        ser.obstructions.addAll(rootGroups);
    }

    private static StreamTokenizer newTokenizer(String line) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
        tokenizer.eolIsSignificant(false);
        tokenizer.lowerCaseMode(false);
        tokenizer.parseNumbers();
        tokenizer.quoteChar(34);
        return tokenizer;
    }

    private static void checkToken(StreamTokenizer tok, int expectedType) throws IOException {
        int type = tok.nextToken();
        if (type != expectedType) {
            throw new IOException(Intl.intl("Could not read file"));
        }
    }

    private static String readString(StreamTokenizer tok) throws IOException {
        BimImporter.checkToken(tok, 34);
        return tok.sval;
    }

    private static double readDouble(StreamTokenizer tok) throws IOException {
        BimImporter.checkToken(tok, -2);
        return tok.nval;
    }

    private static int readInt(StreamTokenizer tok) throws IOException {
        BimImporter.checkToken(tok, -2);
        return (int)tok.nval;
    }

    private static void skipChar(StreamTokenizer tok, char c) throws IOException {
        BimImporter.checkToken(tok, c);
    }

    private static ModelComposite parseGroup(String line, Map<ModelComposite, Integer> groupParentMap) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        int parentid = BimImporter.readInt(tok);
        String name = BimImporter.readString(tok);
        ModelComposite group = new ModelComposite(name);
        groupParentMap.put(group, parentid);
        return group;
    }

    private static Surface parseMaterial(String line) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        String name = BimImporter.readString(tok);
        Surface surf = new Surface(name);
        return surf;
    }

    private static AABoxGeom readGeom(StreamTokenizer tok) throws IOException {
        double minx = BimImporter.readDouble(tok);
        double maxx = BimImporter.readDouble(tok);
        double miny = BimImporter.readDouble(tok);
        double maxy = BimImporter.readDouble(tok);
        double minz = BimImporter.readDouble(tok);
        double maxz = BimImporter.readDouble(tok);
        return new AABoxGeom(new Point3d(minx, miny, minz), new Point3d(maxx, maxy, maxz), 0);
    }

    private static FDSObject parseSolid(String line, List<ModelComposite> groups, Surface defSurf, List<Surface> surfaces) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        int parentid = BimImporter.readInt(tok);
        String name = BimImporter.readString(tok);
        int matlid = BimImporter.readInt(tok);
        AABoxGeom geom = BimImporter.readGeom(tok);
        Surface surf = matlid != -1 ? surfaces.get(matlid) : defSurf;
        Obstruction obj = new Obstruction(name, geom, new Surface[]{surf});
        if (parentid != -1) {
            groups.get(parentid).add(obj);
            return obj;
        }
        return null;
    }

    private static FDSObject parseHole(String line, List<ModelComposite> groups) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        int parentid = BimImporter.readInt(tok);
        String name = BimImporter.readString(tok);
        AABoxGeom geom = BimImporter.readGeom(tok);
        Hole obj = new Hole(name, geom);
        if (parentid != -1) {
            groups.get(parentid).add(obj);
            return obj;
        }
        return null;
    }
}

