/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.tasks.SelectTask;
import pyrosim.legacy_2012_1.domain.tasks.Tasks;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;

public class ExplodeTask
extends CompositeTask<PyroMod> {
    public ExplodeTask(PyroMod mediator, Collection<? extends IModelObj> objs) {
        super(mediator);
        ObstDecorator obstDec = new ObstDecorator();
        EmptyDecorator holeDec = new EmptyDecorator();
        ArrayList<IPyroObject> addObjs = new ArrayList<IPyroObject>();
        ArrayList<IModelObj> delObjs = new ArrayList<IModelObj>();
        for (IModelObj iModelObj : objs) {
            IPyroObject toAdd;
            List<IGeom> explodedGeom = ExplodeTask.explodeGeom(iModelObj);
            if (explodedGeom == null) continue;
            List<IModelObj> newObjs = Collections.EMPTY_LIST;
            if (iModelObj instanceof IObstruction) {
                newObjs = ExplodeTask.explodeFDSObject((IObstruction)iModelObj, explodedGeom, obstDec);
            } else if (iModelObj instanceof IHole) {
                newObjs = ExplodeTask.explodeFDSObject((IHole)iModelObj, explodedGeom, holeDec);
            } else if (iModelObj instanceof GenericGeomSrc) {
                newObjs = ExplodeTask.explode((GenericGeomSrc)iModelObj, explodedGeom);
            }
            if (newObjs.size() == 1) {
                toAdd = newObjs.get(0);
            } else {
                ModelComposite group = new ModelComposite(iModelObj.getName());
                group.addAll(newObjs);
                toAdd = group;
            }
            delObjs.add(iModelObj);
            addObjs.add(toAdd);
        }
        if (!addObjs.isEmpty()) {
            SelectTask task = new SelectTask(mediator, addObjs);
            task.addTask(Tasks.replace(delObjs, addObjs, true));
            this.addTask(task);
        }
    }

    private static List<GenericGeomSrc> explode(GenericGeomSrc obj, List<IGeom> explodedGeoms) {
        IPropsSrc masterProps = obj.getDisplayProps();
        ArrayList<GenericGeomSrc> result = new ArrayList<GenericGeomSrc>(explodedGeoms.size());
        int primOffset = 0;
        for (IGeom geom : explodedGeoms) {
            int numPrims = geom.getNumPrims(7);
            PropsBuilder props = new PropsBuilder();
            props.add(masterProps.subset(primOffset, numPrims), numPrims, false);
            IPropsSrc newProps = props.finalizeProps();
            GenericGeomSrc newObj = (GenericGeomSrc)obj.clone();
            newObj.setGeom(geom, true);
            newObj.setDisplayProps(newProps);
            result.add(newObj);
            primOffset += numPrims;
        }
        return result;
    }

    private static <T extends FDSObject> List<T> explodeFDSObject(T obj, List<IGeom> explodedGeoms, Decorator<T> decorator) {
        Color[] colors = obj.getColors();
        int colorIx = 0;
        decorator.begin(obj);
        ArrayList<FDSObject> newObjs = new ArrayList<FDSObject>(explodedGeoms.size());
        for (IGeom geomObj : explodedGeoms) {
            int numColors = geomObj.getNumPrims(7);
            Color[] subColors = ExplodeTask.subArray(colors, colorIx, numColors);
            colorIx += numColors;
            FDSObject newObj = (FDSObject)obj.clone();
            newObj.setGeom(geomObj, true);
            newObj.setColors(subColors);
            decorator.decorateNext(newObj);
            newObjs.add(newObj);
        }
        return newObjs;
    }

    private static List<IGeom> explodeGeom(IPyroGeomSrc obj) {
        IGeom geom = obj.getGeom();
        Matrix4d xform = null;
        if (geom instanceof TransformedGeom) {
            TransformedGeom tg = (TransformedGeom)geom;
            tg = TransformedGeom.collapse(tg);
            xform = tg.xform;
            geom = tg.geom;
        }
        if (!(geom instanceof GeomGroup) || !geom.canExplode()) {
            return null;
        }
        ArrayList<IGeom> resultGeom = new ArrayList<IGeom>();
        geom.explode(resultGeom);
        if (xform != null) {
            for (int m = 0; m < resultGeom.size(); ++m) {
                IGeom xformed = ((IGeom)resultGeom.get(m)).transform(xform, IGeom.XformOp.RETAINED);
                resultGeom.set(m, xformed);
            }
        }
        return resultGeom;
    }

    private static <T> T[] subArray(T[] baseArray, int offset, int count) {
        if (baseArray.length == 1) {
            return baseArray;
        }
        return Arrays.copyOfRange(baseArray, offset, offset + count);
    }

    private static class EmptyDecorator<T extends FDSObject>
    implements Decorator<T> {
        private EmptyDecorator() {
        }

        @Override
        public void begin(T obj) {
        }

        @Override
        public void decorateNext(T newObj) {
        }
    }

    private static class ObstDecorator
    implements Decorator<IObstruction> {
        private Surface[] d_surfs;
        private int d_surfIx;

        private ObstDecorator() {
        }

        @Override
        public void begin(IObstruction obj) {
            this.d_surfs = obj.getSurfaces();
            this.d_surfIx = 0;
        }

        @Override
        public void decorateNext(IObstruction newObj) {
            int numSurfs = newObj.getGeom().getNumPrims(1);
            Surface[] subSurfs = (Surface[])ExplodeTask.subArray(this.d_surfs, this.d_surfIx, numSurfs);
            this.d_surfIx += numSurfs;
            newObj.setSurfaces(subSurfs);
        }
    }

    private static interface Decorator<T extends FDSObject> {
        public void begin(T var1);

        public void decorateNext(T var1);
    }
}

