/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class AttachedPointLoc
implements Serializable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    public final UnitPoint3D d_location;
    public final Vector3d d_faceNormal;
    public final UnitDouble d_rotation;
    private static final Vector3d s_baseRotVec = new Vector3d(0.0, 0.0, -1.0);

    public AttachedPointLoc() {
        this(Geometry.UP3D_ZERO);
    }

    public AttachedPointLoc(UnitPoint3D location) {
        this(location, new Vector3d(0.0, 0.0, -1.0));
    }

    public AttachedPointLoc(UnitPoint3D location, Vector3d faceNormal) {
        this(location, faceNormal, new UnitDouble(0.0, NonSI.DEGREE_ANGLE));
    }

    public AttachedPointLoc(UnitPoint3D location, Vector3d faceNormal, UnitDouble rotation) {
        this.d_location = location;
        this.d_faceNormal = faceNormal;
        this.d_rotation = rotation;
    }

    @Override
    public pyrosim.domain.geom.AttachedPointLoc fromLegacy(LegacyDictionary_2012_1 dict) {
        return new pyrosim.domain.geom.AttachedPointLoc(this.d_location.fromLegacy(dict), this.d_faceNormal, this.d_rotation.fromLegacy(dict));
    }

    public AttachedPointLoc setLoc(Point3d p) {
        return new AttachedPointLoc(new UnitPoint3D(p, Geometry.LU), this.d_faceNormal, this.d_rotation);
    }

    public Matrix4d toTransform() {
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        xform.setTranslation(this.d_location.getVector3dValue(Geometry.LU));
        if (!s_baseRotVec.equals(this.d_faceNormal)) {
            Vector3d axis = Util3D.cross(s_baseRotVec, this.d_faceNormal);
            double angle = s_baseRotVec.angle(this.d_faceNormal);
            xform.mul(Util.rotMat(axis.x, axis.y, axis.z, angle));
        }
        return xform;
    }

    public FreePointLoc toFreePoint() {
        return new FreePointLoc(this.d_location, this.d_faceNormal, this.d_rotation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttachedPointLoc)) {
            return false;
        }
        AttachedPointLoc loc = (AttachedPointLoc)obj;
        return this.d_location.equals(loc.d_location) && this.d_faceNormal.equals(loc.d_faceNormal) && this.d_rotation.equals(loc.d_rotation);
    }

    public int hashCode() {
        return 596934774 + this.d_location.hashCode() + this.d_faceNormal.hashCode() + this.d_rotation.hashCode();
    }

    public void getBounds(AABox bb, Unit u) {
        bb.add(this.d_location.getValue(u));
    }

    public UnitAABox getBounds() {
        AABox box = new AABox();
        this.getBounds(box, Geometry.LU);
        return new UnitAABox(box, Geometry.LU);
    }

    public AttachedPointLoc transform(Matrix4d xform) {
        UnitPoint3D newLoc = Geometry.xform(xform, this.d_location);
        Vector3d newNormal = Util3D.xform(xform, this.d_faceNormal);
        newNormal.normalize();
        return new AttachedPointLoc(newLoc, newNormal, this.d_rotation);
    }
}

