/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.hvac;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.devices.ADevice;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.util.Util;

public abstract class HvacDevice
extends ADevice {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;

    public HvacDevice(String name, IQuantity msr) {
        super(name);
        this.d_msr = msr;
    }

    public IQuantity getQuantity() {
        return this.d_msr;
    }

    public void setQuantity(IQuantity msr) {
        this.d_msr = msr;
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    private static Point3d getPointForNode(HvacNode n) {
        if (n != null && n.getProp("XYZ") != null) {
            return ((UnitPoint3D)n.getProp("XYZ")).getPoint3dValue((Unit)SI.METER);
        }
        return null;
    }

    public static boolean isValidQuantity(IQuantity quantity) {
        if (!(quantity instanceof ObjectQuantity)) {
            return false;
        }
        ObjectQuantity oq = (ObjectQuantity)quantity;
        for (Object o : oq.objects) {
            if (!(o instanceof HvacDuct) && !(o instanceof HvacNode)) continue;
            return true;
        }
        return false;
    }

    public static class NodeDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public NodeDevice(String devcId, IQuantity msr) {
            super(devcId, msr);
        }

        @Override
        public IGeom getGeom() {
            ObjectQuantity quant = (ObjectQuantity)this.getQuantity();
            Collection<HvacNode> nodes = Util.filter(Arrays.asList(quant.objects), HvacNode.class);
            if (nodes.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            if (quant.get() == Quantity.HVAC_NODE_PRESSURE_DIFFERENCE) {
                assert (nodes.size() == 2);
            } else {
                HvacNode node = nodes.iterator().next();
                Point3d pt = HvacDevice.getPointForNode(node);
                if (pt != null) {
                    return new Point(pt);
                }
                System.err.printf("[x] Unable to find location for NodeDevice (%s)%n", node.getName());
            }
            return EmptyGeom.INSTANCE;
        }
    }

    public static class DuctDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public DuctDevice(String devcId, IQuantity msr) {
            super(devcId, msr);
        }

        @Override
        public IGeom getGeom() {
            ObjectQuantity quant = (ObjectQuantity)this.getQuantity();
            Collection<HvacDuct> ducts = Util.filter(Arrays.asList(quant.objects), HvacDuct.class);
            if (ducts.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            HvacDuct duct = ducts.iterator().next();
            List endNodes = (List)duct.getProp("NODE_ID");
            if (endNodes == null || endNodes.isEmpty() || endNodes.get(0) == null) {
                System.err.printf("[x] Unable to find location for DUCT (%s)%n", duct.getName());
                return EmptyGeom.INSTANCE;
            }
            if (endNodes.size() < 2) {
                Point3d pt = HvacDevice.getPointForNode((HvacNode)endNodes.get(0));
                if (pt != null) {
                    return new Point(pt);
                }
                System.err.printf("[xx] Unable to find location for DUCT (%s)%n", duct.getName());
            } else {
                Point3d ptA = HvacDevice.getPointForNode((HvacNode)endNodes.get(0));
                Point3d ptB = HvacDevice.getPointForNode((HvacNode)endNodes.get(1));
                if (ptA != null && ptB != null) {
                    Point3d p = Util3D.getMidPoint(ptA, ptB);
                    return new Point(p);
                }
                System.err.printf("[xxx] Unable to find location for DUCT (%s)%n", duct.getName());
            }
            return EmptyGeom.INSTANCE;
        }
    }
}

