/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.util.Arrays;
import java.util.List;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.devices.ADevice;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.devices.detectors.IDetector;
import pyrosim.legacy_2012_1.domain.signals.ILatchable;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class Timer
extends ADevice
implements IDetector,
ILatchable,
Cloneable {
    static final long serialVersionUID = 1L;
    private LogicOutPin d_alarmPin = new LogicOutPin(this);
    private final AlarmInfo d_alarmInfo;

    public Timer(UnitDouble tripTime, boolean initiallyOn) {
        this(Intl.intl("TIMER"), tripTime, initiallyOn);
    }

    public Timer(String name, UnitDouble tripTime, boolean initiallyOn) {
        super(name);
        this.d_alarmInfo = new AlarmInfo(tripTime, TripFlags.toFlags(true, initiallyOn));
    }

    public AlarmInfo getAlarmInfo() {
        return this.d_alarmInfo;
    }

    public int hashCode() {
        return 50330243 + this.getName().hashCode() + this.d_alarmInfo.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)obj;
        return super.equals(obj) && this.d_alarmInfo.equals(timer.d_alarmInfo);
    }

    @Override
    public Object clone() {
        Timer clone = (Timer)super.clone();
        clone.d_alarmPin = (LogicOutPin)this.d_alarmPin.clone(this);
        return clone;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public IGeom getGeom() {
        return EmptyGeom.INSTANCE;
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_alarmPin);
    }

    @Override
    public int getTripFlags() {
        return this.d_alarmInfo.tripFlags;
    }

    @Override
    public void setTripFlags(int tf) {
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return TripFlags.latch(this.d_alarmInfo.tripFlags);
    }
}

