/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.IDeviceModel;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SmokeLinkModel
extends NamedPyroObject
implements IDeviceModel,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private UnitDouble d_actObsc;
    private ExSpec d_smokeSpecies;
    private ISpec d_spec;

    public SmokeLinkModel(String name) {
        this(name, SIUS.newud(3.28, 31), null, new Cleary());
    }

    public SmokeLinkModel(String name, UnitDouble activationObscuration, ExSpec smokeSpec, ISpec spec) {
        super(name);
        this.d_actObsc = activationObscuration;
        this.d_smokeSpecies = smokeSpec;
        this.d_spec = spec;
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return super.equals(obj) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SmokeLinkModel)) {
            return false;
        }
        SmokeLinkModel mod = (SmokeLinkModel)obj;
        return this.d_actObsc.equals(mod.d_actObsc) && theUtil.equal(this.d_smokeSpecies, mod.d_smokeSpecies) && this.d_spec.equals(mod.d_spec);
    }

    public int propHash() {
        return this.d_actObsc.hashCode() + theUtil.hashCode(this.d_smokeSpecies) + this.d_spec.hashCode();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_smokeSpecies);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof ExSpec) {
            return new AReplaceRefTask<ExSpec>((Object)old, (Object)replacement){

                @Override
                protected void set(ExSpec obj) {
                    SmokeLinkModel.this.setSmokeSpecies(obj);
                }
            };
        }
        return null;
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof ExSpec) {
            Util.removeAllNotOfType(objs, ExSpec.class);
        }
    }

    public UnitDouble getActivationObscuration() {
        return this.d_actObsc;
    }

    public void setActivationObscuration(UnitDouble actObs) {
        this.d_actObsc = actObs;
        this.changedEvt(new Object[0]);
    }

    public ExSpec getSmokeSpecies() {
        return this.d_smokeSpecies;
    }

    public void setSmokeSpecies(ExSpec spec) {
        this.d_smokeSpecies = spec;
        this.changedEvt(new Object[0]);
    }

    public ISpec getSpec() {
        return this.d_spec;
    }

    public void setSpec(ISpec spec) {
        this.d_spec = spec;
        this.changedEvt(new Object[0]);
    }

    public static class Cleary
    implements ISpec {
        static final long serialVersionUID = 1L;
        public final double d_cAlpha;
        public final double d_cBeta;
        public final double d_eAlpha;
        public final double d_eBeta;

        public Cleary() {
            this(1.8, 1.0, 0.0, 1.0);
        }

        public Cleary(double cAlpha, double cBeta, double eAlpha, double eBeta) {
            this.d_cAlpha = cAlpha;
            this.d_cBeta = cBeta;
            this.d_eAlpha = eAlpha;
            this.d_eBeta = eBeta;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Cleary)) {
                return false;
            }
            Cleary cleary = (Cleary)obj;
            return this.d_cAlpha == cleary.d_cAlpha && this.d_cBeta == cleary.d_cBeta && this.d_eAlpha == cleary.d_eAlpha && this.d_eBeta == cleary.d_eBeta;
        }

        public int hashCode() {
            return theUtil.hashCode(this.d_cAlpha + this.d_cBeta + this.d_eAlpha + this.d_eBeta);
        }
    }

    public static class Heskestad
    implements ISpec {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_length;

        public Heskestad() {
            this(new UnitDouble(1.8, (Unit)SI.METER));
        }

        public Heskestad(UnitDouble length) {
            this.d_length = length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Heskestad)) {
                return false;
            }
            Heskestad spec = (Heskestad)obj;
            return this.d_length.equals(spec.d_length);
        }

        public int hashCode() {
            return -2092433667 + this.d_length.hashCode();
        }
    }

    public static interface ISpec
    extends Serializable {
    }
}

