/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpeciesInjection;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class SpecInjList
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int MASS_FLUX = 0;
    public static final int MASS_FRACTION = 1;
    public final int injType;
    public final TimeBasedValue<Object> d_bgInjection;
    private final Map<ExSpec, SpeciesInjection> d_injections;

    public SpecInjList() {
        this(0, null, new ArrayList<SpeciesInjection>(0));
    }

    public SpecInjList(int injType, TimeBasedValue<Object> bgInjection, List<SpeciesInjection> injections) {
        this.injType = injType;
        this.d_bgInjection = bgInjection;
        this.d_injections = new IdentityHashMap<ExSpec, SpeciesInjection>(injections.size());
        for (SpeciesInjection inj : injections) {
            this.d_injections.put(inj.species, inj);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpecInjList)) {
            return false;
        }
        SpecInjList list = (SpecInjList)obj;
        return this.injType == list.injType && theUtil.equal(this.d_bgInjection, list.d_bgInjection) && Util.identityMapsEqual(this.d_injections, list.d_injections);
    }

    public Collection<SpeciesInjection> getInjections() {
        return this.d_injections.values();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_injections.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.removeAllNotOfType(objs, ExSpec.class);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (!this.d_injections.containsKey(old)) {
            return null;
        }
        return new AUndoableTask(){
            private SpeciesInjection d_inj;
            private boolean d_replAdded;

            @Override
            public void undo() {
                if (this.d_replAdded) {
                    SpecInjList.this.d_injections.remove(replacement);
                }
                SpecInjList.this.d_injections.put(this.d_inj.species, this.d_inj);
            }

            @Override
            public void run() {
                this.d_inj = (SpeciesInjection)SpecInjList.this.d_injections.remove(old);
                if (replacement != null && !SpecInjList.this.d_injections.containsKey(replacement)) {
                    SpeciesInjection newInj = new SpeciesInjection((ExSpec)replacement, this.d_inj.val, this.d_inj.func);
                    SpecInjList.this.d_injections.put((ExSpec)replacement, newInj);
                    this.d_replAdded = true;
                } else {
                    this.d_replAdded = false;
                }
            }
        };
    }
}

