/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class ReacByproducts
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    public final double d_nuFuel;
    public final double d_nuWater;
    public double d_nuResidue;
    private Material d_residue;
    public final UnitDouble d_heat;

    public ReacByproducts() {
        this(0.0, 0.0, 0.0, null, null);
    }

    public ReacByproducts(double nuFuel, double nuWater, double nuResidue, Material residue, UnitDouble heat) {
        assert (nuFuel + nuWater + nuResidue <= 1.000001);
        this.d_nuFuel = nuFuel;
        this.d_nuWater = nuWater;
        this.d_nuResidue = nuResidue;
        if (this.d_nuResidue > 0.0) {
            assert (residue != null);
            this.d_residue = residue;
        } else {
            this.d_residue = null;
        }
        this.d_heat = heat;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReacByproducts)) {
            return false;
        }
        ReacByproducts byp = (ReacByproducts)obj;
        return this.d_nuFuel == byp.d_nuFuel && this.d_nuWater == byp.d_nuWater && this.d_nuResidue == byp.d_nuResidue && theUtil.equal(this.d_residue, byp.d_residue) && theUtil.equal(this.d_heat, byp.d_heat);
    }

    public Material getResidue() {
        return this.d_residue;
    }

    public boolean residueCreatesCycle(Material residue) {
        for (Reaction reaction : residue.getPyrolysis().getReactions()) {
            ReacByproducts byprod = reaction.d_byproducts;
            if (byprod != this && (byprod.d_residue == null || !this.residueCreatesCycle(byprod.d_residue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_residue);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.removeAllNotOfType(objs, Material.class);
        Iterator<T> replit = objs.iterator();
        while (replit.hasNext()) {
            Material residue = (Material)replit.next();
            if (residue == null || !this.residueCreatesCycle(residue)) continue;
            replit.remove();
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (old != this.d_residue) {
            return null;
        }
        return new AUndoableTask(){
            private double d_oldNu;

            @Override
            public void undo() {
                ReacByproducts.this.d_residue = (Material)old;
                ReacByproducts.this.d_nuResidue = this.d_oldNu;
            }

            @Override
            public void run() {
                this.d_oldNu = ReacByproducts.this.d_nuResidue;
                ReacByproducts.this.d_residue = (Material)replacement;
                if (ReacByproducts.this.d_residue == null) {
                    ReacByproducts.this.d_nuResidue = 0.0;
                }
            }
        };
    }
}

