/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.Stack;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public class Material
extends NamedPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object EVT_FYI = new Object();
    private ThermalProps d_thermalProps;
    private IPyrolysis d_pyrolysis;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public Material(String name) {
        this(name, new SolidPyrolysis(), new ThermalProps());
    }

    public Material(String name, IPyrolysis pyrolysis, ThermalProps thermalProps) {
        super(name);
        this.d_pyrolysis = pyrolysis;
        this.d_thermalProps = thermalProps;
        this.d_fyi = "";
        this.d_customFDSProps = new CustomFDSProps();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Material)) {
            return false;
        }
        Material mat = (Material)obj;
        return super.equals(obj) && this.d_thermalProps.equals(mat.d_thermalProps) && this.d_pyrolysis.equals(mat.d_pyrolysis) && this.d_customFDSProps.equals(mat.d_customFDSProps);
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    public boolean isValidResidue(Material mat) {
        return !mat.getResidues().contains(this);
    }

    public boolean hasValidResidues() {
        return this.getResidues() != null;
    }

    public Set<Material> getResidues() {
        return Material.getResidues(this);
    }

    private static Set<Material> getResidues(Material root) {
        IdentityHashSet<Material> closed = new IdentityHashSet<Material>();
        Stack<Material> open = new Stack<Material>();
        open.push(root);
        while (!open.isEmpty()) {
            Material mat = (Material)open.pop();
            if (!closed.add(mat)) {
                return null;
            }
            for (Reaction reaction : mat.d_pyrolysis.getReactions()) {
                Material residue = reaction.d_byproducts.getResidue();
                if (residue == null) continue;
                open.push(residue);
            }
        }
        return closed;
    }

    public boolean isSolid() {
        return this.d_pyrolysis instanceof SolidPyrolysis;
    }

    public boolean isLiquid() {
        return this.d_pyrolysis instanceof LiquidPyrolysis;
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    public IPyrolysis getPyrolysis() {
        return this.d_pyrolysis;
    }

    public void setPyrolysis(IPyrolysis pyrolysis) {
        this.d_pyrolysis = pyrolysis;
        this.changedEvt(new Object[0]);
    }

    public ThermalProps getThermalProps() {
        return this.d_thermalProps;
    }

    public void setThermalProps(ThermalProps props) {
        this.d_thermalProps = props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean invokesMixFrac() {
        for (Reaction reaction : this.d_pyrolysis.getReactions()) {
            if (!(reaction.d_byproducts.d_nuFuel > 0.0)) continue;
            return true;
        }
        return false;
    }
}

