/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public abstract class TimeFunction<ValType>
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final ValType val;

    public TimeFunction(ValType val) {
        this.val = val;
    }

    public static TimeFunction newDefault() {
        return new TanH();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeFunction)) {
            return false;
        }
        TimeFunction tf = (TimeFunction)obj;
        return this.val.equals(tf.val);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        return 9581714 + this.val.hashCode();
    }

    public static class Custom
    extends TimeFunction<Ramp> {
        static final long serialVersionUID = 1L;

        public Custom(Ramp val) {
            super(val);
        }

        public static boolean isRampValid(Ramp ramp, boolean requiresT0) {
            if (ramp.getTUnitType() != 2 || ramp.getFUnitType() != 28) {
                return false;
            }
            if (!requiresT0) {
                return true;
            }
            UnitDouble t0 = new UnitDouble(0.0, (Unit)SI.SECOND);
            for (Ramp.Entry entry : ramp.getRecords()) {
                if (!entry.t.equals(t0)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Custom && super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 374809418;
        }
    }

    public static class TSquared
    extends TimeFunction<UnitDouble> {
        static final long serialVersionUID = 1L;

        public TSquared() {
            this(new UnitDouble(1.0, (Unit)SI.SECOND));
        }

        public TSquared(UnitDouble val) {
            super(val);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TSquared && super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 36999738;
        }
    }

    public static class TanH
    extends TimeFunction<UnitDouble> {
        static final long serialVersionUID = 1L;

        public TanH() {
            this(new UnitDouble(1.0, (Unit)SI.SECOND));
        }

        public TanH(UnitDouble val) {
            super(val);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TanH && super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 337972;
        }
    }
}

