/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.units;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jscience.physics.units.ConversionException;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;

public class UnitDouble
implements Serializable,
Cloneable,
Comparable {
    static final long serialVersionUID = 1L;
    private double d_value;
    private Unit d_unit = null;

    public UnitDouble() {
    }

    public UnitDouble(UnitDouble ud) {
        this(ud.d_value, ud.d_unit);
    }

    public UnitDouble(double value, Unit unit) throws ConversionException {
        this.d_value = value;
        this.d_unit = unit;
    }

    private Unit handleClassUpdate(Unit unitRequested) {
        if (this.d_unit != null && unitRequested != null || this.d_unit == null && unitRequested == null) {
            return unitRequested;
        }
        Unit unitToDetermineOtherUnit = this.d_unit != null ? this.d_unit : unitRequested;
        Unit vel = SI.METER.divide((Unit)SI.SECOND);
        Unit rti = SI.METER.multiply((Unit)SI.SECOND).root(2);
        Object determinedUnit = null;
        determinedUnit = unitToDetermineOtherUnit.isCompatible((Unit)SI.METER) ? SI.METER : (unitToDetermineOtherUnit.isCompatible(SI.CELSIUS) ? SI.CELSIUS : (unitToDetermineOtherUnit.isCompatible((Unit)SI.SECOND) ? SI.SECOND : (unitToDetermineOtherUnit.isCompatible(vel) ? vel : (unitToDetermineOtherUnit.isCompatible(rti) ? rti : SI.METER))));
        if (this.d_unit == null) {
            this.d_unit = determinedUnit;
            return unitRequested;
        }
        return determinedUnit;
    }

    private static void handleClassUpdate(UnitDouble value1, UnitDouble value2) {
        value2.d_unit = value1.handleClassUpdate(value2.d_unit);
    }

    public double getValue(Unit unit) throws ConversionException {
        double returnValue = 0.0;
        if ((unit = this.handleClassUpdate(unit)) == null && this.d_unit == null) {
            UnitDouble.badSit();
            return this.d_value;
        }
        if (this.d_unit == unit) {
            returnValue = this.d_value;
        } else if (this.d_unit.isCompatible(unit)) {
            returnValue = this.d_unit.getConverterTo(unit).convert(this.d_value);
        } else {
            throw new ConversionException("Cannot convert from " + this.d_unit + " to " + unit + ".");
        }
        return returnValue;
    }

    public double getValueNoUnit() {
        return this.d_value;
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public static double convert(double value, Unit from, Unit to) throws ConversionException {
        UnitDouble tempUnit = new UnitDouble(value, from);
        to = tempUnit.handleClassUpdate(to);
        from = tempUnit.d_unit;
        if (to == null && from == null) {
            UnitDouble.badSit();
            return value;
        }
        if (from.isCompatible(to)) {
            return from.getConverterTo(to).convert(value);
        }
        throw new ConversionException("Cannot convert from " + from + " to " + to + ".");
    }

    public UnitDouble diff(UnitDouble val) {
        if (this.d_unit == val.d_unit) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, this.d_unit);
        }
        if (this.d_unit == null && val.d_unit != null) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, val.d_unit);
        }
        if (this.d_unit != null && val.d_unit == null) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, this.d_unit);
        }
        if (this.d_unit == null && val.d_unit == null) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, null);
        }
        Unit otherUnit = val.getUnit();
        Converter cvt = otherUnit.getConverterTo(this.d_unit);
        double otherVal = cvt.convert(val.d_value);
        double diff = Math.abs(this.d_value - otherVal);
        return new UnitDouble(diff, this.d_unit);
    }

    public UnitDouble add(UnitDouble rhs) throws ConversionException {
        Unit unit = rhs.getUnit();
        if ((unit = this.handleClassUpdate(unit)) == null && this.d_unit == null) {
            UnitDouble.badSit();
        }
        double newValue = 0.0;
        if (this.d_unit == unit) {
            newValue = this.d_value + rhs.d_value;
        } else if (this.d_unit.isCompatible(unit)) {
            newValue = this.d_value + unit.getConverterTo(this.d_unit).convert(rhs.d_value);
        } else {
            throw new ConversionException("Cannot convert from " + this.d_unit + " to " + unit + ".");
        }
        return new UnitDouble(newValue, this.d_unit);
    }

    public UnitDouble negate() {
        return new UnitDouble(-this.d_value, this.d_unit);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static UnitDouble min(UnitDouble ud1, UnitDouble ud2) throws ConversionException {
        UnitDouble ud;
        Unit unit2;
        UnitDouble.handleClassUpdate(ud1, ud2);
        if (ud1.d_unit == null && ud2.d_unit == null) {
            UnitDouble.badSit();
            return ud1.d_value < ud2.d_value ? ud1 : ud2;
        }
        Unit unit1 = ud1.getUnit();
        if (unit1 == (unit2 = ud2.getUnit())) {
            ud = ud1.getValue(unit1) < ud2.getValue(unit2) ? ud1 : ud2;
        } else if (unit1.isCompatible(unit2)) {
            ud = ud1.getValue(unit1) < unit2.getConverterTo(unit1).convert(ud2.getValue(unit2)) ? ud1 : ud2;
        } else {
            throw new ConversionException("Cannot convert from " + unit1 + " to " + unit2 + ".");
        }
        return ud;
    }

    public static UnitDouble max(UnitDouble ud1, UnitDouble ud2) throws ConversionException {
        UnitDouble ud;
        Unit unit2;
        UnitDouble.handleClassUpdate(ud1, ud2);
        if (ud1.d_unit == null && ud2.d_unit == null) {
            UnitDouble.badSit();
            return ud1.d_value > ud2.d_value ? ud1 : ud2;
        }
        Unit unit1 = ud1.getUnit();
        if (unit1 == (unit2 = ud2.getUnit())) {
            ud = ud1.getValue(unit1) > ud2.getValue(unit2) ? ud1 : ud2;
        } else if (unit1.isCompatible(unit2)) {
            ud = ud1.getValue(unit1) > unit2.getConverterTo(unit1).convert(ud2.getValue(unit2)) ? ud1 : ud2;
        } else {
            throw new ConversionException("Cannot convert from " + unit1 + " to " + unit2 + ".");
        }
        return ud;
    }

    public int compareTo(Object obj) throws ConversionException {
        int result;
        UnitDouble d = (UnitDouble)obj;
        Unit unit = this.handleClassUpdate(d.getUnit());
        if (unit == null && this.d_unit == null) {
            UnitDouble.badSit();
            return Double.compare(this.d_value, d.d_value);
        }
        if (this.d_unit == unit) {
            result = Double.compare(this.d_value, d.d_value);
        } else if (this.d_unit.isCompatible(unit)) {
            result = Double.compare(this.d_value, unit.getConverterTo(this.d_unit).convert(d.d_value));
        } else {
            throw new ConversionException("Cannot convert from " + this.d_unit + " to " + this.d_unit + ".");
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitDouble)) {
            return false;
        }
        UnitDouble val = (UnitDouble)obj;
        if (this.d_unit != null && val.d_unit == null || this.d_unit == null && val.d_unit != null) {
            return false;
        }
        if (this.d_unit != null && val.d_unit != null && !this.d_unit.isCompatible(val.d_unit)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public boolean tolEquals(UnitDouble obj) {
        if (obj == null) {
            return false;
        }
        double a = this.d_value;
        double b = UnitDouble.convert(obj.getValue(obj.getUnit()), obj.getUnit(), this.getUnit());
        double diff = Math.abs(a - b);
        if (diff == 0.0) {
            return true;
        }
        double tol = Math.abs(Math.min(a, b) / 1000000.0);
        return diff <= tol;
    }

    private static void badSit() {
    }

    public String format(NumberFormat nf) {
        return nf.format(this.d_value) + " " + this.d_unit;
    }

    public String toString() {
        return this.d_value + " " + this.d_unit;
    }
}

