/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private static final int DefaultBufferSize = 8192;
    private byte[] d_buf;
    private int d_bufEnd = 0;
    private int d_bufPos = 0;
    private long d_realPos = 0L;

    public BufferedRandomAccessFile(String name, String mode) throws FileNotFoundException {
        super(name, mode);
        this.init(8192);
    }

    public BufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.init(8192);
    }

    public BufferedRandomAccessFile(String name, String mode, int bufsize) throws FileNotFoundException {
        super(name, mode);
        this.init(bufsize);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufsize) throws FileNotFoundException {
        super(file, mode);
        this.init(bufsize);
    }

    private void init(int bufSize) {
        this.invalidate();
        this.d_buf = new byte[bufSize];
    }

    @Override
    public final int read() throws IOException {
        if (this.d_bufPos >= this.d_bufEnd && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.d_bufEnd == 0) {
            return -1;
        }
        return this.d_buf[this.d_bufPos++];
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.d_buf, 0, this.d_buf.length);
        if (n >= 0) {
            this.d_realPos += (long)n;
            this.d_bufEnd = n;
            this.d_bufPos = 0;
        }
        return n;
    }

    private void invalidate() {
        this.d_bufEnd = 0;
        this.d_bufPos = 0;
        try {
            this.d_realPos = super.getFilePointer();
        }
        catch (IOException e) {
            this.d_realPos = 0L;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int leftover = this.d_bufEnd - this.d_bufPos;
        if (len <= leftover) {
            System.arraycopy(this.d_buf, this.d_bufPos, b, off, len);
            this.d_bufPos += len;
            return len;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
        }
        return len;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.d_realPos;
        return l - (long)this.d_bufEnd + (long)this.d_bufPos;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.d_realPos - pos);
        if (n >= 0 && n <= this.d_bufEnd) {
            this.d_bufPos = this.d_bufEnd - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }

    public final String getNextLine() throws IOException {
        String str = null;
        if (this.d_bufEnd - this.d_bufPos <= 0 && this.fillBuffer() < 0) {
            throw new IOException("error in filling buffer!");
        }
        int lineend = -1;
        for (int i = this.d_bufPos; i < this.d_bufEnd; ++i) {
            if (this.d_buf[i] != 10) continue;
            lineend = i;
            break;
        }
        if (lineend < 0) {
            int c;
            StringBuffer input = new StringBuffer(256);
            while ((c = this.read()) != -1 && c != 10) {
                input.append((char)c);
            }
            if (c == -1 && input.length() == 0) {
                return null;
            }
            return input.toString();
        }
        str = lineend > 0 && this.d_buf[lineend - 1] == 13 ? new String(this.d_buf, this.d_bufPos, lineend - this.d_bufPos - 1) : new String(this.d_buf, this.d_bufPos, lineend - this.d_bufPos);
        this.d_bufPos = lineend + 1;
        return str;
    }
}

