/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v16;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Vector2d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class Wall
extends AbstractFDSObject {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 6;
    private static final String[] FDS_FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    public static final byte FACE_XMIN = 0;
    public static final byte FACE_XMAX = 1;
    public static final byte FACE_YMIN = 2;
    public static final byte FACE_YMAX = 3;
    public static final byte FACE_ZMIN = 4;
    public static final byte FACE_ZMAX = 5;
    public static final byte FACE_AB = 0;
    public static final byte FACE_ABP = 1;
    public static final byte FACE_A = 2;
    public static final byte FACE_B = 3;
    public static final byte FACE_BOTTOM = 4;
    public static final byte FACE_TOP = 5;
    private UnitPoint2D d_a;
    private UnitPoint2D d_b;
    private UnitDouble d_top;
    private UnitDouble d_bottom;
    private UnitDouble d_thickness;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;
    private transient Vector2d d_lastThicknessVector = null;
    private volatile FDSObject[] d_cachedRasterization = null;

    public Wall(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness, Material mat) {
        this(a, b, bottom, top, thickness, "Obstruction", mat);
    }

    public Wall(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness, String description, Material mat) {
        super(description);
        this.d_a = a;
        this.d_b = b;
        this.d_bottom = bottom;
        this.d_top = top;
        this.d_thickness = thickness;
        this.initFaces(new Material[]{mat, mat, mat, mat, mat, mat});
    }

    private void initFaces(Material[] materials) {
        this.d_faces = new Vector(6);
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            int fdsFaceIndex = this.internalFaceIndexToFDSIndex(i);
            this.d_faces.add(this.createFace(this, i, materials[fdsFaceIndex]));
        }
    }

    protected IFace createFace(Wall wall, byte internalFaceIndex, Material mat) {
        return new BlockFace(wall, internalFaceIndex, mat);
    }

    public void invalidateRasterizationCache() {
        if (!this.isAligned()) {
            this.d_cachedRasterization = null;
            ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
        }
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof Wall)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        Wall obj = (Wall)baseObject;
        Iterator<IFace> faceIter = this.getFaceIterator();
        while (faceIter.hasNext()) {
            BlockFace f = (BlockFace)faceIter.next();
            f.d_block = this;
        }
        this.d_a = (UnitPoint2D)obj.d_a.clone();
        this.d_b = (UnitPoint2D)obj.d_b.clone();
        this.d_top = (UnitDouble)obj.d_top.clone();
        this.d_bottom = (UnitDouble)obj.d_bottom.clone();
        this.d_thickness = (UnitDouble)obj.d_thickness.clone();
        this.d_thicken = obj.d_thicken;
        this.d_permitHole = obj.d_permitHole;
        this.d_sawtooth = obj.d_sawtooth;
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Wall b = (Wall)obj;
        return this.d_a.equals(b.d_a) && this.d_b.equals(b.d_b) && this.d_top.equals(b.d_top) && this.d_bottom.equals(b.d_bottom) && this.d_thickness.equals(b.d_thickness) && this.d_thicken == b.d_thicken && this.d_permitHole == b.d_permitHole && this.d_sawtooth == b.d_sawtooth;
    }

    @Override
    public String getPropertyHashString() {
        String s = super.getPropertyHashString();
        s = s + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return s;
    }

    public UnitPoint2D getStartPoint() {
        return this.d_a;
    }

    public void setStartPoint(UnitPoint2D startPoint) {
        this.d_a = startPoint;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitPoint2D getEndPoint() {
        return this.d_b;
    }

    public void setEndPoint(UnitPoint2D endPoint) {
        this.d_b = endPoint;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getBottom() {
        return this.d_bottom;
    }

    public void setBottom(UnitDouble bottom) {
        this.d_bottom = bottom;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getTop() {
        return this.d_top;
    }

    public void setTop(UnitDouble top) {
        this.d_top = top;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getThickness() {
        return this.d_thickness;
    }

    public void setThickness(UnitDouble thickness) {
        this.d_thickness = thickness;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    private Vector2d getThicknessVector(double thickness, Unit u) {
        Vector2d thick;
        double d_errTol = 1.0E-15;
        double dx = this.d_b.x.getValue(u) - this.d_a.x.getValue(u);
        double dy = this.d_b.y.getValue(u) - this.d_a.y.getValue(u);
        if (Math.abs(dx) < 1.0E-15 && Math.abs(dy) < 1.0E-15) {
            if (this.d_lastThicknessVector != null) {
                return this.d_lastThicknessVector;
            }
            thick = new Vector2d(1.0, 0.0);
        } else {
            thick = new Vector2d(-dy, dx);
            thick.normalize();
        }
        thick.scale(thickness);
        this.d_lastThicknessVector = new Vector2d(thick);
        return thick;
    }

    public boolean isAligned() {
        return this.d_a.x.equals(this.d_b.x) || this.d_a.y.equals(this.d_b.y);
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry superGeom = new Geometry();
        super.getGeometry(superGeom);
        Point3D thisMin = superGeom.getMinPoint();
        return new UnitPoint3D(thisMin.x, thisMin.y, thisMin.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry superGeom = new Geometry();
        super.getGeometry(superGeom);
        Point3D thisMax = superGeom.getMaxPoint();
        return new UnitPoint3D(thisMax.x, thisMax.y, thisMax.z, Geometry.GEOM_LENGTH_UNIT);
    }

    public FDSObject[] rasterizeToAllGrids() {
        PyroMod pyMod = this.getDomains().iterator().next();
        Vector<FDSObject> chunks = new Vector<FDSObject>();
        for (Grid g : pyMod.getGridManager()) {
            FDSObject[] currChunks = this.rasterizeToGrid(g);
            if (currChunks == null) continue;
            chunks.addAll(new VectorFromArray<FDSObject>(currChunks));
        }
        return chunks.toArray(new AlignedBlock[chunks.size()]);
    }

    public FDSObject[] rasterizeToGrid(Grid grid) {
        return null;
    }

    protected FDSObject createAlignedSegment(UnitPoint3D min, UnitPoint3D max, Material mat, String name) {
        AlignedBlock segment = new AlignedBlock(min, max, name, mat);
        segment.setColor(this.getColor());
        segment.setIsSawtoothed(this.d_sawtooth);
        segment.setIsThickened(this.d_thicken);
        segment.setPermitsHole(this.d_permitHole);
        return segment;
    }

    @Override
    public void getGeometry(Geometry g) {
        boolean previewMode;
        PyroMod model = this.getDomains().iterator().next();
        boolean bl = previewMode = model.isPreviewMode() && !model.getGridManager().isEmpty() && !this.isAligned();
        if (previewMode) {
            if (this.d_cachedRasterization == null) {
                this.d_cachedRasterization = this.rasterizeToAllGrids();
                assert (this.d_cachedRasterization != null);
            }
            for (int i = 0; i < this.d_cachedRasterization.length; ++i) {
                this.d_cachedRasterization[i].getGeometry(g);
            }
        } else {
            super.getGeometry(g);
        }
    }

    private int getBoundingDivisionIndex(double[] divisions, double bound, boolean useLower) {
        int boundIndex = Arrays.binarySearch(divisions, bound);
        if (boundIndex < 0) {
            boundIndex = -(boundIndex + 1);
            if (useLower) {
                --boundIndex;
            }
        }
        if (boundIndex < 0) {
            boundIndex = 0;
        } else if (boundIndex >= divisions.length) {
            boundIndex = divisions.length - 1;
        }
        return boundIndex;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        if (this.isAligned()) {
            FDSInputRecord rec = new FDSInputRecord();
            rec.setType(this.getFDSType());
            Vector<Double> coords = new Vector<Double>(6);
            Unit fdsUnit = FdsSISystem.getInstance().getLengthUnit();
            Point3D minPoint = this.getMinPoint().getValue(fdsUnit);
            Point3D maxPoint = this.getMaxPoint().getValue(fdsUnit);
            coords.add(minPoint.x);
            coords.add(maxPoint.x);
            coords.add(minPoint.y);
            coords.add(maxPoint.y);
            coords.add(minPoint.z);
            coords.add(maxPoint.z);
            rec.setValue("XB", coords);
            Color c = this.getColor();
            if (c != null) {
                float[] rgb = c.getRGBComponents(null);
                Vector<Double> color = new Vector<Double>(3);
                color.add(Double.valueOf(rgb[0]));
                color.add(Double.valueOf(rgb[1]));
                color.add(Double.valueOf(rgb[2]));
                rec.setValue("RGB", color);
            }
            rec.setComment(this.getName());
            this.fillInputRecordExtras(rec);
            Collection eventRecords = this.getEventInputRecords(rec);
            if (eventRecords.size() != 0) {
                recs.addAll(eventRecords);
            } else {
                recs.add(rec);
            }
        } else {
            FDSObject[] rasterBlocks;
            PyroMod pyMod = this.getDomains().iterator().next();
            if (!pyMod.getGridManager().isEmpty() && (rasterBlocks = this.rasterizeToAllGrids()) != null) {
                for (int i = 0; i < rasterBlocks.length; ++i) {
                    rasterBlocks[i].getInputRecords(recs);
                }
            }
        }
    }

    protected void fillInputRecordExtras(FDSInputRecord rec) {
        int[] internalIndicies = new int[]{this.fdsFaceIndexToInternalIndex(0), this.fdsFaceIndexToInternalIndex(1), this.fdsFaceIndexToInternalIndex(2), this.fdsFaceIndexToInternalIndex(3), this.fdsFaceIndexToInternalIndex(4), this.fdsFaceIndexToInternalIndex(5)};
        if (this.isUniformMaterial()) {
            rec.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(internalIndicies[0])).getMaterial() == ((IFace)this.d_faces.get(internalIndicies[1])).getMaterial() && ((IFace)this.d_faces.get(internalIndicies[0])).getMaterial() == ((IFace)this.d_faces.get(internalIndicies[2])).getMaterial() && ((IFace)this.d_faces.get(internalIndicies[0])).getMaterial() == ((IFace)this.d_faces.get(internalIndicies[3])).getMaterial()) {
            VectorFromArray<String> mats = new VectorFromArray<String>(((IFace)this.d_faces.get(internalIndicies[5])).getMaterial().getName(), ((IFace)this.d_faces.get(internalIndicies[0])).getMaterial().getName(), ((IFace)this.d_faces.get(internalIndicies[4])).getMaterial().getName());
            rec.setValue("SURF_IDS", mats);
        } else {
            Vector<String> mats = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                BlockFace face = (BlockFace)this.d_faces.get(internalIndicies[i]);
                mats.add(face.getMaterial().getName());
            }
            rec.setValue("SURF_ID6", mats);
        }
        rec.setValue("PERMIT_HOLE", this.d_permitHole);
        rec.setValue("SAWTOOTH", this.d_sawtooth);
        rec.setValue("THICKEN", this.d_thicken);
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    protected int fdsFaceIndexToInternalIndex(int fdsIndex) {
        for (int m = 0; m < this.d_faces.size(); ++m) {
            int faceFDSIndex = this.internalFaceIndexToFDSIndex(m);
            if (fdsIndex != faceFDSIndex) continue;
            return m;
        }
        return -1;
    }

    protected int internalFaceIndexToFDSIndex(int internalIndex) {
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        double thickness = this.getThickness().getValue(u);
        int orientation = this.d_a.x.getValue(u) < this.d_b.x.getValue(u) ? (thickness < 0.0 ? 1 : 0) : (this.d_a.x.getValue(u) > this.d_b.x.getValue(u) ? (thickness < 0.0 ? 3 : 2) : (this.d_a.y.getValue(u) < this.d_b.y.getValue(u) ? (thickness < 0.0 ? 5 : 4) : (thickness < 0.0 ? 7 : 6)));
        switch (orientation) {
            case 0: {
                switch (internalIndex) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return internalIndex;
            }
            case 1: {
                switch (internalIndex) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return internalIndex;
            }
            case 2: {
                switch (internalIndex) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return internalIndex;
            }
            case 3: {
                switch (internalIndex) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return internalIndex;
            }
            case 4: {
                switch (internalIndex) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return internalIndex;
            }
            case 5: {
                switch (internalIndex) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return internalIndex;
            }
            case 6: {
                switch (internalIndex) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return internalIndex;
            }
            case 7: {
                switch (internalIndex) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return internalIndex;
            }
        }
        return internalIndex;
    }

    @Override
    public void setMaterial(int fdsFaceIndex, Material mat) {
        int internalIndex = this.fdsFaceIndexToInternalIndex(fdsFaceIndex);
        ((IFace)this.d_faces.get(internalIndex)).setMaterial(mat);
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void fireDomainEvent(IDomainEvent evt) {
        if (evt instanceof FDSObjectDomainEvent) {
            int eventType = ((FDSObjectDomainEvent)evt).getEventType();
            switch (eventType) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.d_cachedRasterization = null;
                }
            }
        }
        ADomainObject.fireDomainEvent(this, evt);
    }

    public void resumeUpdates(IDomainEvent evt) {
        if (evt instanceof FDSObjectDomainEvent) {
            int eventType = ((FDSObjectDomainEvent)evt).getEventType();
            switch (eventType) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.d_cachedRasterization = null;
                }
            }
        }
        ADomainObject.resumeUpdates(this, evt);
    }

    @Override
    public Material getMaterial(int fdsFaceIndex) {
        int internalIndex = this.fdsFaceIndexToInternalIndex(fdsFaceIndex);
        return ((IFace)this.d_faces.get(internalIndex)).getMaterial();
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean hole) {
        this.d_permitHole = hole;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean d_sawtooth) {
        this.d_sawtooth = d_sawtooth;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean d_thicken) {
        this.d_thicken = d_thicken;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Wall";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    public static class BlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Wall d_block;
        private byte d_index;

        public BlockFace(Wall block, byte index, Material material) {
            super(material);
            this.d_block = block;
            this.d_index = index;
        }

        @Override
        public String getName() {
            return FDS_FACE_NAMES[this.d_index];
        }

        @Override
        public void getGeometry(Geometry g) {
        }

        protected Color getDefaultColor() {
            return this.getMaterial().getColor();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof BlockFace)) {
                return false;
            }
            BlockFace bf = (BlockFace)obj;
            return this.d_index == bf.d_index;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            byte index;
            ObjectInputStream.GetField gf = stream.readFields();
            this.d_index = index = gf.get("d_index", (byte)0);
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }
}

