/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import pyrosim.legacy_2006_2.domain.Material;

public class MaterialList
extends Hashtable {
    static final long serialVersionUID = 1L;
    private MaterialList d_parent = null;
    private pyrosim.legacy_2006_2.domain.MaterialList d_newParent = null;

    public MaterialList() {
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = ois.readFields();
        Object parent = fields.get("d_parent", null);
        if (parent != null && parent instanceof MaterialList) {
            this.d_parent = (MaterialList)parent;
        } else if (parent != null && parent instanceof pyrosim.legacy_2006_2.domain.MaterialList) {
            this.d_newParent = (pyrosim.legacy_2006_2.domain.MaterialList)parent;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MaterialList)) {
            return false;
        }
        MaterialList other = (MaterialList)obj;
        if (this.d_parent != null && !this.d_parent.equals(other.d_parent)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int size() {
        return this.getNumLeafMats();
    }

    public int getNumMats() {
        if (this.d_parent != null) {
            return this.d_parent.getNumMats() + this.getNumLeafMats();
        }
        return this.getNumLeafMats();
    }

    public int getNumLeafMats() {
        return super.size();
    }

    public MaterialList(MaterialList matList) {
        this.setParent(matList);
        if (matList == null) {
            // empty if block
        }
    }

    public void addMaterial(Material mat) {
        if (this.getMaterial(mat.getName()) == null) {
            this.put(mat.getName(), mat);
        }
    }

    public Material getMaterial(String name) {
        if (this.containsKey(name)) {
            return (Material)this.get(name);
        }
        if (this.d_parent != null) {
            return this.d_parent.getMaterial(name);
        }
        return null;
    }

    public boolean remove(String name) {
        return super.remove(name) != null;
    }

    public Material[] getAllMaterials() {
        List allKeys = this.getKeyListUnion();
        ArrayList<Material> allMats = new ArrayList<Material>(allKeys.size());
        for (int i = 0; i < allKeys.size(); ++i) {
            allMats.add(this.getMaterial((String)allKeys.get(i)));
        }
        return allMats.toArray(new Material[this.size()]);
    }

    public Material[] getLeafMaterials() {
        return this.values().toArray(new Material[this.size()]);
    }

    public boolean isLeafMat(String name) {
        return this.containsKey(name);
    }

    public List getKeyListUnion() {
        ArrayList v = new ArrayList();
        v.addAll(this.keySet());
        MaterialList curParent = this.d_parent;
        while (curParent != null) {
            v.addAll(curParent.keySet());
            curParent = curParent.d_parent;
        }
        return v;
    }

    public MaterialList getParent() {
        return this.d_parent;
    }

    public pyrosim.legacy_2006_2.domain.MaterialList getNewParent() {
        return this.d_newParent;
    }

    public void setParent(MaterialList parent) {
        if (parent != null && parent.d_parent != null && parent.d_parent.d_parent != null) {
            throw new IllegalArgumentException("3-level parenting is max for MaterialList.");
        }
        this.d_parent = parent;
    }

    @Override
    public Object clone() {
        MaterialList parentClone = null;
        if (this.d_parent != null) {
            parentClone = (MaterialList)this.d_parent.clone();
        }
        MaterialList res = new MaterialList(parentClone);
        Material[] leaves = this.getAllMaterials();
        for (int m = 0; m < leaves.length; ++m) {
            Material newMat = (Material)leaves[m].clone();
            res.addMaterial(newMat);
        }
        return res;
    }

    public List getAllNames() {
        ArrayList<String> names = new ArrayList<String>(this.size());
        Material[] allMats = this.getAllMaterials();
        for (int m = 0; m < allMats.length; ++m) {
            names.add(allMats[m].getName());
        }
        return names;
    }
}

