/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.Ramp;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Warning;

class SurfProcessor
extends AFDSRecordProcessor {
    private Map<String, Collection<UnitlessRampRecord>> d_allRampRecords = new TreeMap<String, Collection<UnitlessRampRecord>>();
    private Map<String, MaterialRecPair> d_tempMats = new TreeMap<String, MaterialRecPair>();

    public SurfProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
        for (Material m : this.getContainer().getMaterials()) {
            if (Material.isPredefinedMaterial(m.getName())) continue;
            this.d_tempMats.put(m.getName(), new MaterialRecPair(m, null));
        }
    }

    @Override
    public String getFDSTypeParsed() {
        return "SURF";
    }

    private BufferedImage getTexImage(String fn) throws IOException {
        FilenameFilter texfilter;
        File dbDir = super.getParsingInfo().getContainer().getDBDir();
        File texDir = dbDir.listFiles(texfilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("textures");
            }
        })[0];
        File texFile = new File(texDir, fn);
        if (texFile.exists()) {
            return ImageIO.read(texFile);
        }
        String fileDir = super.getParsingInfo().getCurrentParsingFile();
        File curDir = new File(fileDir = fileDir.substring(0, fileDir.lastIndexOf(System.getProperty("file.separator"))));
        File texFile2 = new File(curDir, fn);
        if (texFile2.exists()) {
            BufferedImage orig = ImageIO.read(texFile2);
            BufferedImage compat = new BufferedImage(orig.getWidth(), orig.getHeight(), orig.getType());
            Graphics2D g2d = compat.createGraphics();
            g2d.drawImage(orig, null, 0, 0);
            g2d.dispose();
            return compat;
        }
        return null;
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        FDSParsingInfo pi = this.getParsingInfo();
        boolean err = false;
        try {
            if ("SURF".equals(rec.getType())) {
                PartRecord part;
                Material newMat;
                String texFn;
                String name = (String)rec.getValue("ID");
                if (name == null || name.equals("")) {
                    throw new FDSRecordFormatException(rec, "Every SURF must have an ID.");
                }
                if (Material.isPredefinedMaterial(name)) {
                    return true;
                }
                Color c = this.parseColor(rec);
                if (c == null) {
                    c = pi.getDefaultMaterial().getColor();
                }
                if ((texFn = (String)rec.getValue("TEXTURE_MAP")) != null) {
                    TextureDB texDB = this.getContainer().getTextureDB();
                    DoubleValueRange rng = DoubleValueRange.createCheckedMin(0.0, true);
                    double wid = rec.extractDouble("TEXTURE_WIDTH", 1.0, rng);
                    double ht = rec.extractDouble("TEXTURE_HEIGHT", 1.0, rng);
                    TextureInfo texinfo = null;
                    if (texDB.names().contains(texFn)) {
                        texinfo = new TextureInfo(texDB.getDefaultInfo(texFn));
                    } else if (pi.getCurrentParsingFile() != null) {
                        try {
                            File parseFile = new File(pi.getCurrentParsingFile());
                            File texFile = new File(parseFile.getParentFile(), texFn);
                            texinfo = texDB.addToDB(texFile);
                            if (texinfo != null) {
                                texinfo = new TextureInfo(texinfo);
                                String id = texinfo.getTexID();
                                TextureInfo dInfo = texDB.getDefaultInfo(id);
                                if (rec.getValue("TEXTURE_WIDTH") != null) {
                                    dInfo.setWidth(new UnitDouble(wid, (Unit)SI.METER));
                                }
                                if (rec.getValue("TEXTURE_HEIGHT") != null) {
                                    dInfo.setHeight(new UnitDouble(ht, (Unit)SI.METER));
                                }
                            }
                        }
                        catch (Throwable t) {
                            this.addWarning(rec, "Unable to create texture: " + texFn, "Texture Removed");
                            t.printStackTrace();
                            texinfo = null;
                        }
                    }
                    if (texinfo != null) {
                        if (rec.getValue("TEXTURE_WIDTH") != null) {
                            texinfo.setWidth(new UnitDouble(wid, (Unit)SI.METER));
                        }
                        if (rec.getValue("TEXTURE_HEIGHT") != null) {
                            texinfo.setHeight(new UnitDouble(ht, (Unit)SI.METER));
                        }
                        newMat = new Material(name, c, texinfo);
                    } else {
                        newMat = new Material(name, c);
                    }
                } else {
                    newMat = new Material(name, c);
                }
                for (String valueName : Material.getValueNames()) {
                    Object value = rec.getValue(valueName);
                    if (value == null) continue;
                    if (Material.getRampInfo(valueName) != null) {
                        newMat.setValue(valueName, value);
                        continue;
                    }
                    Material.ValueInfo<?, ?> info = Material.getValueInfo(valueName);
                    if (!info.d_fdsParsingDataType.isInstance(value)) {
                        throw new ClassCastException();
                    }
                    value = info.convertFDSValueToPyroValue(value);
                    newMat.setValue(valueName, value);
                }
                String partID = (String)newMat.getValue("PART_ID");
                if (partID != null && (part = this.getResource(partID, PartRecord.class)) == null) {
                    throw new FDSRecordFormatException(rec, "No particle with the id (PART_ID), \"" + partID + ",\" could be found in the model.");
                }
                if (newMat.getValue("PHASE") == null) {
                    newMat.setValue("PHASE", "SOLID");
                }
                this.d_tempMats.put(newMat.getName(), new MaterialRecPair(newMat, rec));
                return true;
            }
            if ("RAMP".equals(rec.getType())) {
                String name = (String)rec.getValue("ID");
                Double tD = (Double)rec.getValue("T");
                Double fD = (Double)rec.getValue("F");
                if (name == null || tD == null || fD == null) {
                    throw new FDSRecordFormatException(rec, "RAMP records must specify an ID, RAMP_T, and RAMP_F.");
                }
                UnitlessRampRecord rampRec = new UnitlessRampRecord(tD, fD);
                Collection<UnitlessRampRecord> rampRecords = this.d_allRampRecords.get(name);
                if (rampRecords == null) {
                    rampRecords = new Vector<UnitlessRampRecord>();
                    this.d_allRampRecords.put(name, rampRecords);
                }
                rampRecords.add(rampRec);
                return true;
            }
            return false;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            err = true;
        }
        catch (FDSRecordFormatException e4) {
            if (this.getParsingInfo().getDebugLevel() == 0) {
                throw e4;
            }
            return false;
        }
        catch (Exception e) {
            err = true;
        }
        if (err) {
            if (this.getParsingInfo().getDebugLevel() == 0) {
                throw new FDSRecordFormatException(rec);
            }
            return false;
        }
        return true;
    }

    public Material makeMatValid(MaterialRecPair pair) {
        Collection<? extends Warning> warnings = Material.validateMaterial(pair.d_mat);
        for (Warning warning : warnings) {
            this.addWarning(pair.d_rec, warning.getWarning(), warning.getActionTaken());
        }
        return pair.d_mat;
    }

    @Override
    public void done() throws FDSRecordFormatException {
        for (MaterialRecPair pair : this.d_tempMats.values()) {
            for (String rampType : Material.getRampTypes()) {
                String rampName = (String)pair.d_mat.getValue(rampType);
                if (rampName == null) continue;
                Collection<UnitlessRampRecord> unitlessRampRecords = this.d_allRampRecords.get(rampName);
                if (unitlessRampRecords == null) {
                    if (this.getParsingInfo().getDebugLevel() == 0) {
                        if (pair.d_rec != null) {
                            throw new FDSRecordFormatException(pair.d_rec, "The RAMP, " + rampName + ", does not exist in the model.");
                        }
                        throw new FDSRecordFormatException("The RAMP, " + rampName + ", does not exist in the model.");
                    }
                    pair.d_mat.setValue(rampType, null);
                    continue;
                }
                Material.RampInfo rampInfo = Material.getRampInfo(rampType);
                Vector<RampRecord> rampRecords = new Vector<RampRecord>(unitlessRampRecords.size());
                for (UnitlessRampRecord ulrr : unitlessRampRecords) {
                    Unit tUnit = FdsSISystem.getInstance().getUnit(rampInfo.d_tUnit);
                    Unit fUnit = FdsSISystem.getInstance().getUnit(rampInfo.d_fUnit);
                    rampRecords.add(new RampRecord(rampName, new UnitDouble(ulrr.d_k, tUnit), new UnitDouble(ulrr.d_v, fUnit), rampInfo.d_tUnit, rampInfo.d_fUnit));
                }
                Ramp r = new Ramp(rampName, rampRecords);
                pair.d_mat.setValue(rampType, r);
            }
            pair.d_mat.recalcProfilePath();
            pair.d_mat = this.makeMatValid(pair);
            Material existing = this.getContainer().getMaterials().get(pair.d_mat.getName());
            if (existing != null) {
                this.getContainer().getMaterials().taskRemove(existing, pair.d_mat).run();
            } else {
                this.getContainer().getMaterials().taskAdd(pair.d_mat).run();
            }
            this.flagPyroTypeAffected(Material.class);
        }
    }

    private static class UnitlessRampRecord {
        private double d_k;
        private double d_v;

        public UnitlessRampRecord(double k, double v) {
            this.d_k = k;
            this.d_v = v;
        }
    }

    private static class MaterialRecPair {
        Material d_mat;
        FDSInputRecord d_rec;

        public MaterialRecPair(Material mat, FDSInputRecord rec) {
            this.d_mat = mat;
            this.d_rec = rec;
        }
    }
}

