/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitSystem;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class PartProcessor
extends AFDSRecordProcessor {
    private UnitSystem d_unitSystem = FdsSISystem.getInstance();
    private Unit d_densityUnit = this.d_unitSystem.getDensityUnit();
    private Unit d_tempUnit = this.d_unitSystem.getTempUnit();
    private Unit d_specHeatUnit = this.d_unitSystem.getSpecHeatUnit();
    private Unit d_specEnergyUnit = this.d_unitSystem.getSpecEnergyUnit();
    private Unit d_diameterUnit = this.d_unitSystem.getDiameterUnit();
    private Unit d_timeUnit = this.d_unitSystem.getTimeUnit();

    public PartProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "PART";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        try {
            if (rec.getType() == null) {
                throw new Exception();
            }
            if (!"PART".equals(rec.getType())) {
                return false;
            }
            String id = (String)rec.getValue("ID");
            if (id == null || id.equals("")) {
                id = "Particle";
            } else if (this.getContainer().getPartList().contains(id)) {
                throw new FDSRecordFormatException(rec, "Several particles in the model have the same id, \"" + id + ".\" Each particle in a model must have a unique id.");
            }
            PartRecord partRec = new PartRecord(id);
            String[] allKeys = rec.getKeys();
            for (int i = 0; i < allKeys.length; ++i) {
                if (allKeys[i].equals("DENSITY")) {
                    UnitDouble density = rec.extractDouble("DENSITY", this.d_densityUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("DENSITY"));
                    partRec.setDensity(density.getValue(this.d_densityUnit), this.d_densityUnit);
                    continue;
                }
                if (allKeys[i].equals("VAPORIZATION_TEMPERATURE")) {
                    double vapTemp = (Double)rec.getValue("VAPORIZATION_TEMPERATURE");
                    partRec.setVapTemp(vapTemp, this.d_tempUnit);
                    continue;
                }
                if (allKeys[i].equals("MELTING_TEMPERATURE")) {
                    double meltTemp = (Double)rec.getValue("MELTING_TEMPERATURE");
                    partRec.setMeltTemp(meltTemp, this.d_tempUnit);
                    continue;
                }
                if (allKeys[i].equals("SPECIFIC_HEAT")) {
                    UnitDouble specificHeat = rec.extractDouble("SPECIFIC_HEAT", this.d_specHeatUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("SPECIFIC_HEAT"));
                    partRec.setSpecificHeat(specificHeat.getValue(this.d_specHeatUnit), this.d_specHeatUnit);
                    continue;
                }
                if (allKeys[i].equals("HEAT_OF_VAPORIZATION")) {
                    UnitDouble heatVap = rec.extractDouble("HEAT_OF_VAPORIZATION", this.d_specEnergyUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("HEAT_OF_VAPORIZATION"));
                    partRec.setHeatVap(heatVap.getValue(this.d_specEnergyUnit), this.d_specEnergyUnit);
                    continue;
                }
                if (allKeys[i].equals("DIAMETER")) {
                    UnitDouble diameter = rec.extractDouble("DIAMETER", this.d_diameterUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("DIAMETER"));
                    partRec.setDiameter(diameter.getValue(this.d_diameterUnit), this.d_diameterUnit);
                    continue;
                }
                if (allKeys[i].equals("GAMMA_D")) {
                    double gammaD = (Double)rec.getValue("GAMMA_D");
                    partRec.setGamma(gammaD);
                    continue;
                }
                if (allKeys[i].equals("MASSLESS")) {
                    boolean massless = (Boolean)rec.getValue("MASSLESS");
                    partRec.setMassless(massless);
                    continue;
                }
                if (allKeys[i].equals("STATIC")) {
                    boolean staticVar = (Boolean)rec.getValue("STATIC");
                    partRec.setStatic(staticVar);
                    continue;
                }
                if (allKeys[i].equals("FUEL")) {
                    boolean fuel = (Boolean)rec.getValue("FUEL");
                    partRec.setFuel(fuel);
                    continue;
                }
                if (allKeys[i].equals("HEAT_OF_COMBUSTION")) {
                    UnitDouble heatCombust = rec.extractDouble("HEAT_OF_COMBUSTION", this.d_specEnergyUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("HEAT_OF_COMBUSTION"));
                    partRec.setHeatCombust(heatCombust.getValue(this.d_specEnergyUnit), this.d_specEnergyUnit);
                    continue;
                }
                if (allKeys[i].equals("WATER")) {
                    boolean water = (Boolean)rec.getValue("WATER");
                    partRec.setWater(water);
                    continue;
                }
                if (allKeys[i].equals("SAMPLING_FACTOR")) {
                    int sample = ((Double)rec.getValue("SAMPLING_FACTOR")).intValue();
                    partRec.setSample(sample);
                    continue;
                }
                if (allKeys[i].equals("QUANTITY")) {
                    String quantity = (String)rec.getValue("QUANTITY");
                    if (!quantity.equals("none")) {
                        partRec.setQuantity(quantity);
                        continue;
                    }
                    partRec.setQuantity("none");
                    continue;
                }
                if (allKeys[i].equals("NUMBER_INITIAL_DROPLETS")) {
                    int initDropI = rec.extractInt("NUMBER_INITIAL_DROPLETS", 0, (IntValueRange)PartRecord.getValueRange("NUMBER_INITIAL_DROPLETS"));
                    partRec.setInitDrop(initDropI);
                    continue;
                }
                if (allKeys[i].equals("MASS_PER_VOLUME")) {
                    UnitDouble massVol = rec.extractDouble("MASS_PER_VOLUME", this.d_densityUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("MASS_PER_VOLUME"));
                    partRec.setMassVol(massVol.getValue(this.d_densityUnit), this.d_densityUnit);
                    continue;
                }
                if (allKeys[i].equals("DROPLETS_PER_SECOND")) {
                    int dropSec = rec.extractInt("DROPLETS_PER_SECOND", 0, (IntValueRange)PartRecord.getValueRange("DROPLETS_PER_SECOND"));
                    partRec.setDropSec(dropSec);
                    continue;
                }
                if (allKeys[i].equals("AGE")) {
                    UnitDouble age = rec.extractDouble("AGE", this.d_timeUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("AGE"));
                    partRec.setAge(age.getValue(this.d_timeUnit), this.d_timeUnit);
                    continue;
                }
                if (!allKeys[i].equals("INITIAL_TEMPERATURE")) continue;
                Double initTemp = (Double)rec.getValue("INITIAL_TEMPERATURE");
                if (initTemp != null) {
                    partRec.setInitTemp(initTemp, this.d_tempUnit);
                    partRec.setInitTempFDS(false);
                    continue;
                }
                partRec.setInitTempFDS(true);
            }
            this.getContainer().getPartList().taskAdd(partRec).run();
            this.flagPyroTypeAffected(PartRecord.class);
        }
        catch (NullPointerException e1) {
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            err = true;
        }
        catch (FDSRecordFormatException e5) {
            err = true;
            caughtExc = e5;
        }
        catch (Exception e4) {
            err = true;
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

