/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class HeatProcessor
extends AFDSRecordProcessor {
    public HeatProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "HEAT";
    }

    private String getAutoName(HeatDetectorList hdList) {
        int i = 1;
        String name = "HD" + i;
        while (hdList.contains(name)) {
            name = "HD" + ++i;
        }
        return name;
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        HeatDetectorList hdList = this.getContainer().getHeatDetectors();
        FDSRecordFormatException caughtException = null;
        boolean err = false;
        if (!"HEAT".equals(rec.getType())) {
            return false;
        }
        try {
            String label = (String)rec.getValue("LABEL");
            if (label == null || label.equals("")) {
                label = this.getAutoName(hdList);
            }
            if (label.equals("ALL")) {
                throw new FDSRecordFormatException(rec, "A heat detector cannot be named ALL since this name is reserved by FDS.");
            }
            if (this.getContainer().getHeatDetectors().contains(label)) {
                throw new FDSRecordFormatException(rec, "The heat detector, \"" + label + ",\" already exists in the model.");
            }
            Vector location = (Vector)rec.getValue("XYZ");
            if (location == null) {
                throw new FDSRecordFormatException(rec, "A HEAT record must specify a location (XYZ).");
            }
            Unit length = FdsSISystem.getInstance().getLengthUnit();
            double x = (Double)location.get(0);
            double y = (Double)location.get(1);
            double z = (Double)location.get(2);
            UnitPoint3D unitLocation = new UnitPoint3D(x, y, z, length);
            Double rti = (Double)rec.getValue("RTI");
            if (rti == null) {
                throw new FDSRecordFormatException(rec, "A HEAT record must specify a response time index (RTI).");
            }
            UnitDouble unitRTI = new UnitDouble(rti, FdsSISystem.getInstance().getRtiUnit());
            Double actTemp = (Double)rec.getValue("ACTIVATION_TEMPERATURE");
            if (actTemp == null) {
                throw new FDSRecordFormatException(rec, "A HEAT record must specify an activation temperature (ACTIVATION_TEMPERATURE).");
            }
            UnitDouble unitActTemp = new UnitDouble(actTemp, FdsSISystem.getInstance().getTempUnit());
            HeatDetector heatDetector = new HeatDetector(unitLocation, unitRTI, unitActTemp, label);
            this.getContainer().getHeatDetectors().taskAdd(heatDetector).run();
            this.flagPyroTypeAffected(HeatDetector.class);
        }
        catch (ArrayIndexOutOfBoundsException e0) {
            e0.printStackTrace();
            err = true;
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
            err = true;
        }
        catch (ClassCastException e2) {
            e2.printStackTrace();
            err = true;
        }
        catch (FDSRecordFormatException e) {
            e.printStackTrace();
            err = true;
            caughtException = e;
        }
        if (err) {
            if (caughtException != null) {
                throw caughtException;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

